/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger
   co-programmer:

*/

#include "nadion_laser.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"

//
ObjectListDefinition(NadionLaser);
CREATE_FACTORY(NadionLaser);
/**
 * Standard constructor
 */
NadionLaser::NadionLaser ()
 : Weapon()
{
    this->init();
}

NadionLaser::NadionLaser (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
NadionLaser::~NadionLaser()
{
}

void NadionLaser::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void NadionLaser::init()
{
  this->setScaling(.45);

  this->loadModel("models/guns/nadion_laser.obj", this->getScaling());

  this->setStateDuration(WS_SHOOTING, 0.1666);   // 6 shots per second

  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
//   this->setActionSound(WA_ACTIVATE, "sounds/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("NadionBlast");
  this->prepareProjectiles(20);


//   this->setBarrels(1); // could be left out
//   this->setSegs(1);    // could be left out

  this->setEmissionPoint(Vector(1.680, 0.0, 0.0) * this->getScaling());

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void NadionLaser::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

  Vector dir = (this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor()).getNormalized();
  //FIXME direction calculation is a mess, needs to be cleaned up
  // HACK direction AbsDir calulation 
  Vector up = dir.cross(VECTOR_RAND(1));

  //force a resoable up vector
  while (up.len() < .0001)
    up = dir.cross(VECTOR_RAND(1));

  pj->setVelocity(this->getParent()->getVelocity() + (dir)*160);

  pj->setAbsCoor(this->getEmissionPoint());
//   pj->setAbsDir(Quaternion(this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor(), Vector(0,0,0)));
//   pj->setAbsDir(Quaternion(tmp.getNormalized(), this->getParent()->getAbsDir().apply(Vector(0,1,0))));
//   pj->setAbsDir(Quaternion(dir, up.getNormalized()));
  pj->setAbsDir(Quaternion(dir, Vector(1,0,0)));

  pj->setAbsDir(this->getAbsDir());
  pj->activate();

}


/**
 *  this activates the weapon
*/
void NadionLaser::activate()
{
}

/**
 *  this deactivates the weapon
*/
void NadionLaser::deactivate()
{
}

void NadionLaser::draw() const
{
  glPushMatrix();
  glMatrixMode(GL_MODELVIEW);
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    static_cast<StaticModel*>(this->getModel())->draw();
  glPopMatrix();
}

void NadionLaser::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_medium_bold.png");
    this->setEnergyWidgetInitialized(true);
  }
}
