/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer, Nicolas Schlumberger
   co-programmer:

*/

#include "light_blaster.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"

CREATE_FACTORY(LightBlaster);
/**
 * Standard constructor
 */
LightBlaster::LightBlaster ()
 : Weapon()
{
    this->init();
}

LightBlaster::LightBlaster (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
LightBlaster::~LightBlaster()
{

}

void LightBlaster::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void LightBlaster::init()
{

  this->loadModel("models/guns/gatling.obj", 0.333);


  this->setStateDuration(WS_SHOOTING, 0.05);  // 20 Schuss pro Sekunde
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
//   this->setActionSound(WA_ACTIVATE, "sounds/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("LBolt");
  this->prepareProjectiles(25);

  this->setBarrels(3);
//   this->setSegs(1); //could be left out

  this->setEmissionPoint(Vector(2.2, 0.0, 0.1), 0);
  this->setEmissionPoint(Vector(2.2, -0.07, -0.05), 1);
  this->setEmissionPoint(Vector(2.2, 0.07, -0.05), 2);

//   Animation3D* animation1 = this->getAnimation(WS_SHOOTING, this);
  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

//   animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);


  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}

void LightBlaster::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

//   pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*250 + VECTOR_RAND(5));
  pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*180);

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
//   pj->toList(OM_GROUP_01_PROJ);
  pj->activate();

  this->cycleBarrel();
}

/**
 *  this activates the weapon
*/
void LightBlaster::activate()
{
}

/**
 *  this deactivates the weapon
*/
void LightBlaster::deactivate()
{
}

void LightBlaster::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    static_cast<StaticModel*>(this->getModel())->draw();
  glPopMatrix();

}

void LightBlaster::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_light_bolt.png");
    this->setEnergyWidgetInitialized(true);
  }
}
