/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger
   co-programmer:

*/

#include "disruptor.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"

ObjectListDefinition(Disruptor);
CREATE_FACTORY(Disruptor);

/**
 * Standard constructor
 */
Disruptor::Disruptor ()
 : Weapon()
{
    this->init();
}

Disruptor::Disruptor (const TiXmlElement* root = NULL)
 : Weapon()
{
    // TODO add leftRight to params
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
Disruptor::~Disruptor()
{
}

void Disruptor::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void Disruptor::init()
{

  this->setScaling(.5);

  this->loadModel("models/guns/disruptor.obj", this->getScaling());


  this->setStateDuration(WS_SHOOTING, 0.3333);  // 3 Shots per Second
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
//   this->setActionSound(WA_ACTIVATE, "sounds/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("HBolt");
  this->prepareProjectiles(10);

  this->setBarrels(1);
  this->setSegs(1);

  this->setEmissionPoint(Vector(1.672, 0.0, 0.0) * this->getScaling());

  this->getShootAnim(0, 0)->addKeyFrame(Vector(0.0, 0.0, 0.0) * this->getScaling(), Quaternion(), 0.033, ANIM_LINEAR, ANIM_NULL);
  this->getShootAnim(0, 0)->addKeyFrame(Vector(-0.5, 0.0, 0.0) * this->getScaling(), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
//   this->shootAnim[0][0]->addKeyFrame(Vector(0.0, 0.0, 0.0) * this->getScaling(), Quaternion(), 0.1, ANIM_LINEAR, ANIM_NULL);

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void Disruptor::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());
  pj->setParent(PNode::getNullParent());

  Vector tmp = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

//   pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*130 + VECTOR_RAND(1));
  pj->setVelocity((tmp.getNormalized())*130 + VECTOR_RAND(1));

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();


  this->getShootAnim(0, 0)->replay();
}

/**
 *  this activates the weapon
*/
void Disruptor::activate()
{
}

/**
 *  this deactivates the weapon
*/
void Disruptor::deactivate()
{
}


void Disruptor::draw() const
{
  glPushMatrix();
    glMatrixMode(GL_MODELVIEW);
    glTranslatef (this->getAbsCoor ().x,
                  this->getAbsCoor ().y,
                  this->getAbsCoor ().z);
      Vector tmpRot = this->getAbsDir().getSpacialAxis();
      glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

    //Base
    static_cast<StaticModel*>(this->getModel())->draw(1);

    // Barrel
    glPushMatrix();
      glTranslatef(this->getObjCompx(0,0), this->getObjCompy(0,0), this->getObjCompz(0,0));
      static_cast<StaticModel*>(this->getModel())->draw(0);
    glPopMatrix();

  glPopMatrix();
}

void Disruptor::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_heavy_bolt.png");
    this->setEnergyWidgetInitialized(true);
  }
}
