//
//  TowerDefenseEnemy.cc
//  Orxonox
//
//  Created by Jonas Erb on 22.10.14.

/**
@brief
See TowerDefenseReadme.txt for Information.

@ingroup TowerDefense
*/
#include "TowerDefenseEnemy.h"
#include "core/CoreIncludes.h"
//#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(TowerDefenseEnemy);

    /**
    @brief
        Constructor. Registers and initializes the object.
    */
    TowerDefenseEnemy::TowerDefenseEnemy(Context* context) : SpaceShip(context)
    {
        RegisterObject(TowerDefenseEnemy);

        this->setCollisionType(WorldEntity::Dynamic);
        //needed to keep track of the PlayerStats coded in TowerDefense.h
        this->td = orxonox_cast<TowerDefense*>(this->getGametype());
        once_ = false;
    }

    TowerDefenseEnemy::~TowerDefenseEnemy()
    {

    }

    void TowerDefenseEnemy::tick(float dt)
    {   
        //orxout() << "TDE tick1" << endl;
        SUPER(TowerDefenseEnemy, tick, dt);
        //orxout() << "TDE tick2" << endl;
    }

    WeakPtr<TowerDefense> TowerDefenseEnemy::getGame()
    {
        if (game == nullptr)
        {
            for (ObjectList<TowerDefense>::iterator it = ObjectList<TowerDefense>::begin(); it != ObjectList<TowerDefense>::end(); ++it)
                game = *it;
        }
        return game;
    }

    void TowerDefenseEnemy::damage(float damage, float healthdamage, float shielddamage, Pawn* originator)
    {
        Pawn::damage(damage, healthdamage, shielddamage, originator);
        
        if (getGame() && once_ == false && getHealth() <= 0)
        {
            getGame()->addCredit(1);
            once_ = true;
        }
    }
}
