/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */

/**
    @file TowerDefenseCenterpoint.cc
    @brief Implementation of the TowerDefenseCenterpoint class.
*/

#include "TowerDefenseCenterpoint.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "core/class/Super.h"

#include "TowerDefense.h"

namespace orxonox
{
    RegisterClass(TowerDefenseCenterpoint);

    /**
    @brief
        Constructor. Registers and initializes the object and checks whether the gametype is actually TowerDefense.
    */
    TowerDefenseCenterpoint::TowerDefenseCenterpoint(Context* context) : MobileEntity(context)
    {
        RegisterObject(TowerDefenseCenterpoint);

        this->width_ = 15;
        this->height_ = 15;

        //this->setCollisionType(Static);

        this->checkGametype();

    }

    /**
    @brief
        Method to create a TowerDefenseCenterpoint through XML.
    */
    void TowerDefenseCenterpoint::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(TowerDefenseCenterpoint, XMLPort, xmlelement, mode);

        XMLPortParam(TowerDefenseCenterpoint, "width", setWidth, getWidth, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "height", setHeight, getHeight, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tileScale", setTileScale, getTileScale, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "selecterTemplate", setSelecterTemplate, getSelecterTemplate, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower1Template", setTower1Template, getTower1Template, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower2Template", setTower2Template, getTower2Template, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower3Template", setTower3Template, getTower3Template, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower4Template", setTower4Template, getTower4Template, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower5Template", setTower5Template, getTower5Template, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "fields", setFields, getFields, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower1Cost", setTower1Cost, getTower1Cost, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower2Cost", setTower2Cost, getTower2Cost, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower3Cost", setTower3Cost, getTower3Cost, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower4Cost", setTower4Cost, getTower4Cost, xmlelement, mode);
        XMLPortParam(TowerDefenseCenterpoint, "tower5Cost", setTower5Cost, getTower5Cost, xmlelement, mode);
    }

    /**
    @brief
        Checks whether the gametype is TowerDefense and if it is, sets its centerpoint.
    */
    void TowerDefenseCenterpoint::checkGametype()
    {
        if (this->getGametype() != nullptr && this->getGametype()->isA(Class(TowerDefense)))
        {
            // Sets the centerpoint of the gametype. The gametype uses this to later spawn in towers, he needs the tower template stored in the center point
            TowerDefense* towerDefenseGametype = orxonox_cast<TowerDefense*>(this->getGametype());
            towerDefenseGametype->setCenterpoint(this);
        }
    }

    /**
    @brief
        Removes all blanks, tabs and returns from the string passed.
    */
    void TowerDefenseCenterpoint::trimString(std::string* str)
    {
        std::string* trimmed = new std::string("");
        int length = str->size();
        char temp;
        for (int i = 0; i < length; ++ i)
        {
            temp = str->at(i);
            if (temp != ' ' && temp != '\t' && temp != '\n')
            {
                trimmed->push_back(temp);
            }
        }

        *str = *trimmed;
    }

    const int TowerDefenseCenterpoint::getTowerCost(int upgrade) const
    {
        return towerCosts_[(upgrade%5)];
    }
}
