/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger
   co-programmer: 

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "plasma_pulse.h"

#include "state.h"
#include "world_entities/npcs/actionbox_enemy.h"

#include <cassert>
#include "debug.h"

#include "obb_tree.h"


ObjectListDefinition(PlasmaPulse);
CREATE_FAST_FACTORY_STATIC(PlasmaPulse);

/**
 *  standard constructor
*/
PlasmaPulse::PlasmaPulse () : Projectile()
{
  this->registerObject(this, PlasmaPulse::_objectList);


  this->setMinEnergy(2);
  this->setHealthMax(0);
  this->setDamage(2);
  this->lifeSpan = 2.0;
  this->grid = new Billboard();
  this->grid->setSize(.2, .2);
  this->grid->setPulseMagnitude(.8);
  this->grid->setParent(this);
  this->grid->setVisibility(false);
  this->grid->setPulse();
  this->grid->setTexture( "textures/plasma.png");
/*
  this->blink = new Blink();
  this->grid->setParent(this);
  this->grid->setVisibility(false);
  this->blink->setSize(1.0 );
  this->blink->setPeriod(.4);
  this->blink->setColor(10, 250, 150);
  this->blink->loadBlinkSequence( "66678998766" );
  this->blink->toList(OM_ENVIRON);*/
  
  this->obbTree = new OBBTree();
  this->obbTree->createBox(Vector(0.0f, 0.0f, 0.0f), Vector(1.0f, 1.0f, 1.0f));
  this->setOBBTree(this->obbTree);
}


/**
 *  standard deconstructor
 *
 */
PlasmaPulse::~PlasmaPulse ()
{
  this->grid->toList(OM_DEAD);
//   this->blink->toList(OM_DEAD);
}


void PlasmaPulse::activate()
{
//   this->origList = this->getOMListNumber();
  this->grid->setVisibility(true);
//   this->blink->setVisibility(true);

  this->setPhysDamage(10);
  this->setElecDamage(0);
  this->setHealth(0);
}


void PlasmaPulse::deactivate()
{
  this->lifeCycle = 0.0;

  this->grid->setVisibility(false);
//   this->blink->setVisibility(false);
  this->lifeCycle = 0.0;
  this->toList(OM_NULL);
//   this->removeNode();

  PlasmaPulse::fastFactory->kill(this);
}

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void PlasmaPulse::tick (float dt)
{
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  this->grid->tick(dt);
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void PlasmaPulse::destroy (WorldEntity* killer)
{
  this->deactivate();
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY PlasmaPulse\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
}


void PlasmaPulse::draw () const
{
  glPushMatrix();
  glPushAttrib(GL_ENABLE_BIT);
    glEnable( GL_ALPHA_TEST);
    glAlphaFunc( GL_GEQUAL, .5);
    this->grid->draw();
//     this->blink->draw();
  glPopAttrib();
  glPopMatrix();

}
