/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger, Marc Schaerrer
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "hbolt.h"

#include "state.h"
#include "model.h"

#include "world_entities/npcs/actionbox_enemy.h"
#include "world_entities/npcs/npc.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"

#include <cassert>
#include "debug.h"

#include "obb_tree.h"

// #include "effects/billboard.h"
#include "space_ships/space_ship.h"
#include "npcs/npc.h"

ObjectListDefinition(HBolt);
CREATE_FAST_FACTORY_STATIC(HBolt);

/**
 *  standard constructor
*/
HBolt::HBolt () : Projectile()
{
  this->registerObject(this, HBolt::_objectList);

  this->loadModel("models/projectiles/hbolt.obj",1.1);

  this->setMinEnergy(7);
  this->setHealthMax(0);
  this->lifeSpan = 3.0;
  this->setDamage(10);
  this->angle = 0;
//   this->rotationSpeed = 600;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
  this->emitter->setEmissionRate(300.0);
  this->emitter->setEmissionVelocity(50.0);

  this->halo = new Billboard();
  this->halo->setSize(.65, .65);
  this->halo->setTexture("hbolt_halo2.png");
  this->halo->setVisibility(false);
  
  this->obbTree = new OBBTree();
  this->obbTree->createBox(Vector(0.0f, 0.0f, 0.0f), Vector(1.0f, 1.0f, 1.0f));
  this->setOBBTree(this->obbTree);

}


/**
 *  standard deconstructor
*/
HBolt::~HBolt ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (HBolt::explosionParticles != NULL && HBolt::objectList().size() <= 1)
  {
    //if (ClassList::exists(HBolt::explosionParticles, CL_PARTICLE_SYSTEM))
    //  delete HBolt::explosionParticles;
    PRINTF(1)("Deleting HBolt Particles\n");
    HBolt::explosionParticles = NULL;
  }

}

SpriteParticles* HBolt::explosionParticles = NULL;

void HBolt::activate()
{
  this->halo->setVisibility(true);
//   this->origList = this->getOMListNumber();
  //this->toList(OM_ENVIRON);
  if (unlikely(HBolt::explosionParticles == NULL))
  {
    HBolt::explosionParticles = new SpriteParticles(1000);
    HBolt::explosionParticles->setName("HBoltExplosionParticles");
    HBolt::explosionParticles->setLifeSpan(.5, .3);
    HBolt::explosionParticles->setRadius(0.0, 10.0);
    HBolt::explosionParticles->setRadius(.5, 6.0);
    HBolt::explosionParticles->setRadius(1.0, 3.0);
    HBolt::explosionParticles->setColor(0.0, 1,1,0,.9);
    HBolt::explosionParticles->setColor(0.5, .8,.8,0,.5);
    HBolt::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setPhysDamage(100);
  this->setHealth(0);
}


void HBolt::deactivate()
{
  this->halo->setVisibility(false);
  assert (HBolt::explosionParticles != NULL);
  HBolt::explosionParticles->removeEmitter(this->emitter);
  this->lifeCycle = 0.0;

  this->toList(OM_DEAD);
//   this->removeNode();
  HBolt::fastFactory->kill(this);

}


void HBolt::hit (float damage, WorldEntity* entity )
{
  printf("Collision with HBolt\n");
  if (this->hitEntity != entity/* && entity->isA(NPC::staticClassID())*/ && entity->isA(ActionboxEnemy::staticClassID()) || entity == this->target)
    this->destroy( entity );
//   this->hitEntity = entity;
 // dynamic_cast<SpaceShip*>(entity)->damage( this->getPhysDamage(), this->getElecDamage());
  this->deactivate();
}


/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void HBolt::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  this->angle += HBolt::rotationSpeed * dt;
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void HBolt::destroy (WorldEntity* killer)
{
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY HBolt\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(HBolt::explosionParticles);
}


void HBolt::draw () const
{

  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glDisable(GL_FOG);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

//     float matrix[4][4];
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    this->halo->draw();

    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    glRotatef(this->angle, 0.0, 0.0, 1.0);
//     glMultMatrixf((float*)matrix);
    this->getModel()->draw();

  glPopMatrix();
  glPopAttrib();

}
