/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverWall.h
    @brief Declaration of the HoverWall class.
    @ingroup Jump
*/

#ifndef _HoverWall_H__
#define _HoverWall_H__

#include "HoverPrereqs.h"
#include "util/Math.h"
#include "worldentities/StaticEntity.h"
#include "graphics/Model.h"    
#include "objects/collisionshapes/BoxCollisionShape.h"


namespace orxonox
{
    class _HoverExport HoverWall : public StaticEntity
    {
        public:
            HoverWall(Context* context);            
            HoverWall(Context* context, int x, int y);
            virtual ~HoverWall();
            virtual void tick(float dt);
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

        private:
            Model* model_;
            BoxCollisionShape* cs_;

    };
}

#endif /* _HoverWall_H__ */
