/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverWall.cc
    @brief All platforms in this minigame inherit from this class. The basic functions of a platform (interact with figure) is implemented here. Special functions are implemented in the specialized classes.
*/

#include "HoverWall.h"

#include "core/CoreIncludes.h"
#include "core/GameMode.h"
#include "graphics/Model.h"
#include "gametypes/Gametype.h"



#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(HoverWall);

    HoverWall::HoverWall(Context* context) : StaticEntity(context)
    {
        RegisterObject(HoverWall);
        model_ = new Model(context);
        cs_ = new BoxCollisionShape(context);
        model_->setMeshSource("cube.mesh");
        model_->setScale3D(Vector3(100, 30, 2));
        model_->setPosition(Vector3(100,0,100));
        cs_->setPosition(Vector3(100,0,100));
        cs_->setHalfExtents(Vector3(100, 30, 2));



    }

    HoverWall::HoverWall(Context* context, int x, int y) : StaticEntity(context)
    {
        RegisterObject(HoverWall);
        model_ = new Model(context);
        cs_ = new BoxCollisionShape(context);
        model_->setMeshSource("cube.mesh");
        model_->setScale3D(Vector3(50, 30, 2));
        model_->setPosition(Vector3(x*100-50,0,y*100-50));
        cs_->setPosition(Vector3(x*100-50,0,y*100-50));
        cs_->setHalfExtents(Vector3(50, 30, 2));



    }

    /**
    @brief
        Destructor.
    */
    HoverWall::~HoverWall()
    {

    }

    //xml port for loading height and width of the platform
    void HoverWall::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverWall, XMLPort, xmlelement, mode);

       // XMLPortParam(HoverWall, "height", setHeight, getHeight, xmlelement, mode);
        //XMLPortParam(HoverWall, "width", setWidth, getWidth, xmlelement, mode);
    }

    /**
    @brief
        Is called every tick.
        Handles the movement of the ball and its interaction with the boundaries and bats.
    @param dt
        The time since the last tick.
    */
    void HoverWall::tick(float dt)
    {
        SUPER(HoverWall, tick, dt);
        
    }

    
}
