/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *   Co-authors:
 *      ...
 *
 */

/**
    @file Hover.cc
    @brief Implementation of the Hover class.
*/

//#include "orxonox/worldentities/pawns/SpaceShip.h"
#include "Hover.h"

#include "HoverWall.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    bool firstTick = true;
    RegisterUnloadableClass(Hover);

    Hover::Hover(Context* context) : Gametype(context)
    {
        
        RegisterObject(Hover);
        //this->setHUDTemplate("HoverHUD");
    }



    void Hover::tick(float dt)
    {
        SUPER(Hover, tick, dt);

        if(firstTick){
            firstTick = false;
            new HoverWall(origin_->getContext(), 1, 2);
        }      


    }

    

    void Hover::start()
    {

        // Call start for the parent class.
        Gametype::start();

    }


    void Hover::end()
    {
        // DON'T CALL THIS!
        //      Deathmatch::end();
        // It will misteriously crash the game!
        // Instead startMainMenu, this won't crash.
        GSLevel::startMainMenu();
    }
}
