/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "WingmanController.h"


namespace orxonox
{

    RegisterClass(WingmanController);
    static const int RADIUS_TO_SEARCH_FOR_LEADER = 7000;
    static const float ACTION_INTERVAL = 1.0f;
    WingmanController::WingmanController(Context* context) : CommonController(context)
    {
        RegisterObject(WingmanController);
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&WingmanController::action, this)));
        this->myLeader_ = 0;
        this->desiredRelativePosition_ = 0;
    }

    WingmanController::~WingmanController()
    {

    }

    CommonController* WingmanController::findNewLeader()
    {

        if (!this->getControllableEntity())
            return 0;

        CommonController* closestLeader = 0;
        float minDistance =  std::numeric_limits<float>::infinity();

        for (ObjectList<CommonController>::iterator it = ObjectList<CommonController>::begin(); it; ++it)
        {
            //0ptr?
            if (!it || !it->isLeader() || !(it->getControllableEntity()))
                continue;
            //same team?
            if (this->getControllableEntity()->getTeam() != (it)->getControllableEntity()->getTeam())
                continue;
            //is equal to this?
            if (it->getControllableEntity() == this->getControllableEntity())
                continue;

            float distance = (it->getControllableEntity()->getPosition() - this->getControllableEntity()->getPosition()).length();
            if (distance < minDistance && !(it->hasWingman()))
            {
                closestLeader = *it;
                minDistance = distance;
            }
           
        }
        if (closestLeader)
        {
            if (closestLeader->setWingman(this))
                return closestLeader;
        }
        return 0;
    }
    
    void WingmanController::action()
    {
        //this->target_ = this->sectionTarget_;
        if (!this->myLeader_)
        {
            CommonController* newLeader = findNewLeader();
            this->myLeader_ = newLeader;
            if (newLeader)
                orxout(internal_error) << "new Leader set" << endl;
            else
                orxout(internal_error) << "0 leader" << endl;

        }
        else
        {

        }
    }
 /*//collect data for AI behaviour
            Vector3* meanOfEnemiesPtr = new Vector3(0.0,0.0,0.0);
            Vector3* meanOfAlliesPtr  = new Vector3(0.0,0.0,0.0);
            Vector3 meanOfAllies = *meanOfAlliesPtr;
            Vector3 meanOfEnemies = *meanOfEnemiesPtr;


            for (ObjectList<AIController>::iterator it = ObjectList<AIController>::begin(); it; ++it)
            {

                Gametype* gt=this->getGametype();
                if (!gt)
                {
                    gt=it->getGametype();
                }
                if (!FormationController::sameTeam(this->getControllableEntity(), it->getControllableEntity(),gt))
                {
                    enemies_.push_back(*it);
                } 
                else {
                    allies_.push_back(*it);
                } 
            }
            if (enemies_.size() != 0 && allies_.size() != 0){
                for (std::vector<WeakPtr<AIController> >::iterator it = enemies_.begin() ; it != enemies_.end(); ++it)
                    meanOfEnemies += (*it)->getControllableEntity()->getWorldPosition();

                meanOfEnemies /= enemies_.size();

                for (std::vector<WeakPtr<AIController> >::iterator it = allies_.begin() ; it != allies_.end(); ++it)
                    meanOfAllies += (*it)->getControllableEntity()->getWorldPosition();

                meanOfAllies /= allies_.size();

                //orxout(internal_error) << "There are " << enemies_Counter << " enemies_, mean position is " << meanOfEnemies << endl;
                orxout(internal_error) << "Distance is " << (meanOfEnemies-meanOfAllies).length() << endl;
                orxout(internal_error) << "mean of allies_ is " << meanOfAllies << ", with a size " << allies_.size() << endl;
                orxout(internal_error) << "mean of enemies_ is " << meanOfEnemies << ", with a size " << enemies_.size() << endl;
            }*/

     
    /*void WingmanController::keepSectionTick()
    {
        if (this->myLeader_ && this->myLeader_->getControllableEntity())
                            //orxout(internal_error) << "MOVING" << endl;

        if (this->myLeader_ && this->myLeader_->getControllableEntity() && desiredRelativePosition_)
        {
            Vector3 desiredAbsolutePosition = ((this->myLeader_->getControllableEntity()->getWorldPosition()) + 
                (this->myLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
            this->moveToPosition (desiredAbsolutePosition);
        }
    }*/
    void WingmanController::tick(float dt)
    {   
       /* //-------------------------------------------------------
           
        
        if (!this->isActive())
            return;
        //--------------------------Stay in formation--------------------------
        this->keepSectionTick();*/
            
        
        //--------------------------Attack same target as the Leader--------------------------

        /*if (this->target_)
        {
            this->aimAtTarget();
            this->doFire();
        }
*/
        
        //orxout(internal_error) << "I am " << this << endl;

        
        SUPER(WingmanController, tick, dt);
    }

    void WingmanController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(WingmanController, XMLPort, xmlelement, mode);

        //XMLPortParam(SectionController, "target_", setTarget, getTarget, xmlelement, mode).defaultValues(100.0f);
    }

//**********************************************NEW
    /*void WingmanController::defaultBehaviour(float maxrand)
    {  
       
    }*/

}
