/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "SectionController.h"

namespace orxonox
{

    RegisterClass(SectionController);
    static const float ACTION_INTERVAL = 1.0f;

    SectionController::SectionController(Context* context) : LeaderController(context)
    {
        RegisterObject(SectionController);
                this->setFormationMode(WALL);

        bIsDivisionLeader_ = false;
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&SectionController::action, this)));
        this->myWingman_ = 0;
        this->myDivisionLeader_ = 0;
        this->desiredRelativePosition_ = 0;

        orxout(internal_error) << this << "Was created" << endl;

    }
   
    SectionController::~SectionController()
    {
       
    }
    /*void SectionController::setDesiredPositionOfWingman()
    {
        if (!this->myWingman_)
            return;

        switch (this->formationMode_){
            case WALL:
            {
                myWingman_->desiredRelativePosition_ = new Vector3 (-200, 0, 0);   
                break;
            }
            case FINGER4: 
            {
                break;
            }
            case VEE: 
            {
                break;
            }
            case DIAMOND: 
            {
                break;
            }
        }
       
    }
*/
    LeaderController* SectionController::findNewDivisionLeader()
    {

        if (!this->getControllableEntity())
            return 0;

        LeaderController* closestLeader = 0;
        float minDistance =  std::numeric_limits<float>::infinity();
        //go through all pawns
        for (ObjectList<LeaderController>::iterator it = ObjectList<LeaderController>::begin(); it; ++it)
        {
            //0ptr or not DivisionController?
            if (!(it) || !(it)->bIsDivisionLeader_ || !(it->getControllableEntity()))
                continue;
            //same team?
            if ((this->getControllableEntity()->getTeam() != (it)->getControllableEntity()->getTeam()))
                continue;

            //is equal to this?
            if (orxonox_cast<ControllableEntity*>(*it) == this->getControllableEntity())
                continue;


            
           

            float distance = ((it)->getControllableEntity()->getPosition() - this->getControllableEntity()->getPosition()).length();
            
            if (distance < minDistance && !(it->hasFollower()))
            {
                closestLeader = *it;
                minDistance = distance;
            }
           /* // is pawn in range?
            if (distance < RADIUS_TO_SEARCH_FOR_LEADER)
            {

                if ((it)->setFollower(this))
                    return (*it);
            }*/
        }
        if (closestLeader)
        {
            if (closestLeader->setFollower(this))
                return closestLeader;
        }
        return 0;

    }

    void SectionController::action()
    {
        //this->target_ = this->sectionTarget_;        
        if (!myDivisionLeader_)
        {
            LeaderController* newDivisionLeader = findNewDivisionLeader();
            this->myDivisionLeader_ = newDivisionLeader;
            if (newDivisionLeader)
                orxout(internal_error) << "new DivisionLeader set" << endl;

        }
/*        setDesiredPositionOfWingman();
*/    }
    /*
    Wingmen and Leaders attack target_, which is a member variable of their classes.
    Wingmen's target_ is set to sectionTarget_, which is a member variable of SectionController class, unless
    Wingman covers Leader's rear.
    Leader's target_ must always equal sectionTarget_.
    if section has a target, its Leader shoots at it, but doesn't follow.
    Every section is a part of division. Division consisting of one Section is still a division.
    Division's leader's target_ must always equal divisionTarget_, which is a member variable of DivisionController.
    Division leader ONLY can follow target_ while in formation flight.
    If Division doesn't have a target, Division Leader stays in place, unless it has a waypoint.
    Division Leader's sectionTarget_ must equal divisionTarget_,
    but the other section, that is not a leading section, can attack any target that is near divisonTarget_

    */
   /* void SectionController::keepDivisionTick()
    {


        if (this->myDivisionLeader_ && this->myDivisionLeader_->getControllableEntity() && desiredRelativePosition_)
        {

            Vector3 desiredAbsolutePosition = ((this->myDivisionLeader_->getControllableEntity()->getWorldPosition()) + 
                (this->myDivisionLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
            this->moveToPosition (desiredAbsolutePosition);
        }
    }*/
    void SectionController::tick(float dt)
    {
        

       /* 
        if (!this->isActive())
            return;
        
        //--------------------------Stay in division--------------------------
        this->keepDivisionTick();
        */
        //If ordered to move -> move to a target Point
        
        //No orders -> Don't move, but shoot at whatever is close, unless Boss is shooting at it. 
        //(Section shoots same target, Boss's section shoots another target) 
        

        //orxout(internal_error) << "my Wingman is " << this->myWingman_ << endl;
        
        SUPER(SectionController, tick, dt);
    }
    

    void SectionController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SectionController, XMLPort, xmlelement, mode);

        //XMLPortParam(SectionController, "target_", setTarget, getTarget, xmlelement, mode).defaultValues(100.0f);
    }

    
   

}
