/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _DivisionController_H__
#define _DivisionController_H__

#include "controllers/LeaderController.h"


#include "util/Math.h"
#include "tools/Timer.h"
#include "tools/interfaces/Tickable.h"

namespace orxonox
{
    class _OrxonoxExport DivisionController : public LeaderController, public Tickable
      {
        public:
        	DivisionController(Context* context);
        	virtual ~DivisionController();

        	virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

        	//Using british military aircraft formations
        	
     		
			virtual bool setFollower(LeaderController* myFollower);
			virtual bool setWingman(CommonController* wingman)
            {
                if (!this->myWingman_)
                {
                    this->myWingman_ = wingman;
                    return true;
                }
                else
                {
                    return false;
                }
            };
            virtual bool hasWingman()
            {
                if (this->myWingman_)
                    return true;
                else
                    return false;
            }
            virtual bool hasFollower()
            {
                if (this->myFollower_)
                    return true;
                else
                    return false;
            };
            

            virtual void tick(float dt); //<! Carrying out the targets set in action().


        protected:
            void setDesiredPositionOfWingman();
            void setDesiredPositionOfFollower();
            virtual void action(); //<! action() is called in regular intervals managing the bot's behaviour ~ setting targets.

	     	//Target enemy, set by fleet controller.
	        
			
			
	        

	    
        private:
            Timer actionTimer_; //<! Regularly calls action().

    };
}

#endif /* _DivisionController_H__ */
