/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "DivisionController.h"


namespace orxonox
{

    RegisterClass(DivisionController);
    static const float ACTION_INTERVAL = 1.0f;

    DivisionController::DivisionController(Context* context) : LeaderController(context)
    {
        RegisterObject(DivisionController);
        this->setFormationMode(WALL);

        bIsDivisionLeader_ = true;
        this->myFollower_ = 0;
        this->myWingman_ = 0;
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&DivisionController::action, this)));

    }

    DivisionController::~DivisionController()
    {
      
    } 
    void DivisionController::tick(float dt)
    {
        SUPER(DivisionController, tick, dt);

    }
    void DivisionController::action()
    {
/*        setDesiredPositionOfFollower();
        setDesiredPositionOfWingman();*/
    }

    bool DivisionController::setFollower(LeaderController* myFollower)
    {
         if (!this->myFollower_)
        {
            this->myFollower_ = myFollower;
            return true;
        }
        else
        {
            return false;
        }
    }

   /* void DivisionController::setDesiredPositionOfWingman()
    {
        if (!this->myWingman_)
            return;

        switch (this->formationMode_){
            case WALL:
            {
                myWingman_->desiredRelativePosition_ = new Vector3 (200, 0, 0);   
                break;
            }
            case FINGER4: 
            {
                break;
            }
            case VEE: 
            {
                break;
            }
            case DIAMOND: 
            {
                break;
            }
        }
       
    }
    void DivisionController::setDesiredPositionOfFollower()
    {
        if (!this->myFollower_)
            return;

        switch (this->formationMode_){
            case WALL:
            {
                myWingman_->desiredRelativePosition_ = new Vector3 (-200, 0, 0);   
                break;
            }
            case FINGER4: 
            {
                break;
            }
            case VEE: 
            {
                break;
            }
            case DIAMOND: 
            {
                break;
            }
        }
       
    }*/
    void DivisionController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(DivisionController, XMLPort, xmlelement, mode);

        //XMLPortParam(DivisionController, "target_", setTarget, getTarget, xmlelement, mode).defaultValues(100.0f);
    }

    
   

}
