/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */
#include "controllers/CommonController.h"

namespace orxonox
{

    RegisterClass(CommonController);

    
    bool CommonController::setWingman (CommonController* wingman)
    {
        return false;
    }
    bool CommonController::isLeader ()
    {
        return false;
    }
    bool CommonController::hasWingman()
    {
        return true;
    }

    CommonController::CommonController(Context* context) : Controller(context)
    {

        RegisterObject(CommonController);
        //this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&LeaderController::action, this)));
    }


    CommonController::~CommonController()
    {
    }

    void CommonController::moveToPosition(const Vector3& target)
    {
        if (!this->getControllableEntity())
            return;

        Vector2 coord = get2DViewCoordinates(this->getControllableEntity()->getPosition(), this->getControllableEntity()->getOrientation() * WorldEntity::FRONT, this->getControllableEntity()->getOrientation() * WorldEntity::UP, target);
        float distance = (target - this->getControllableEntity()->getPosition()).length();
        float rotateX = clamp(coord.x * 10, -1.0f, 1.0f);
        float rotateY = clamp(coord.y * 10, -1.0f, 1.0f);

        
        if (this->target_ || distance > 10)
        {
            this->getControllableEntity()->rotateYaw(-1.0f * 0.8f * rotateX);
            this->getControllableEntity()->rotatePitch(0.8f * rotateY);
        }

        if (this->target_ && distance <  200 && this->getControllableEntity()->getVelocity().squaredLength() > this->target_->getVelocity().squaredLength())
        {
            this->getControllableEntity()->moveFrontBack(-0.05f); // They don't brake with full power to give the player a chance
        } 
        else if (distance > 100)
            this->getControllableEntity()->moveFrontBack(0.8f);
        


        if (distance < 100)
        {
            this->positionReached();
            bHasTargetOrientation_=false;
        }
    }
 

}
