/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _SectionController_H__
#define _SectionController_H__

#include "controllers/LeaderController.h"

#include "tools/Timer.h"
#include "tools/interfaces/Tickable.h"

namespace orxonox
{
    class _OrxonoxExport SectionController : public LeaderController, public Tickable
    {
        public:
            SectionController(Context* context);
            virtual ~SectionController();
            virtual bool setWingman(CommonController* wingman)
            {
                if (!this->myWingman_)
                {
                    this->myWingman_ = wingman;
                    return true;
                }
                else
                {
                    return false;
                }
            }

            virtual bool hasWingman()
            {
                if (this->myWingman_)
                    return true;
                else
                    return false;
            }

            virtual void tick(float dt); //<! Carrying out the targets set in action().

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
            LeaderController* findNewDivisionLeader();

        protected:
            void setDesiredPositionOfWingman();
            void keepDivisionTick();
            //A division is the biggest block of spaceships.
            //In division one section is leading, the other one always stays on the same position
            //relative to the Leader of the leading section.
            //In section a Wingman always stays on same position relative to the Leader.
            //That position is desiredRelativePosition_
            virtual void action(); //<! action() is called in regular intervals managing the bot's behaviour ~ setting targets.


           

        
        private:
            Timer actionTimer_; //<! Regularly calls action().
            

    };
}

#endif /* _SectionController_H__ */
