/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _LeaderController_H__
#define _LeaderController_H__

#include "controllers/CommonController.h"
#include "controllers/WingmanController.h"


#include "util/Math.h"


namespace orxonox
{
    class _OrxonoxExport LeaderController : public CommonController
    {
        public:
               static const int RADIUS_TO_SEARCH_FOR_LEADER = 3000;

            LeaderController(Context* context);
            virtual ~LeaderController();
            virtual bool isLeader()
            {
                return true;
            };
            bool bIsDivisionLeader_;
            virtual bool setFollower(LeaderController* myFollower)
            {
                return false;
            };
            virtual bool bIsDivisionLeader()
            {
                return bIsDivisionLeader_;
            };
            virtual bool hasFollower()
            {
                return true;
            };
            WeakPtr<CommonController> myWingman_;

            WeakPtr<LeaderController> myFollower_;
            WeakPtr<LeaderController> myDivisionLeader_;


        protected:
           


            //void defaultBehaviour(float maxrand); //<! Helper function for code reusage. Some concrete commands for a bot.    
         
        private:
            
            
            
            //Timer actionTimer_; //<! Regularly calls action().
               
    };
}

#endif /* _LeaderController_H__ */
