/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _CommonController_H__
#define _CommonController_H__


#include "controllers/Controller.h"
#include "worldentities/ControllableEntity.h"

namespace orxonox
{
    class _OrxonoxExport CommonController : public Controller
    {
        public:
            enum FormationMode {VEE,FINGER4,DIAMOND, WALL};
            virtual void setFormationMode(FormationMode val)
                { this->formationMode_ = val; }
            inline FormationMode getFormationMode() const
                { return this->formationMode_; }

            CommonController(Context* context);
            virtual ~CommonController();
            virtual bool isLeader();
            virtual bool setWingman(CommonController* wingman);
            virtual bool hasWingman();
            Vector3* desiredRelativePosition_;


        protected:
            void moveToPosition(const Vector3& target);
            virtual void positionReached() {}

        /*    void moveToTargetPosition();
            void absoluteMoveToPosition(const Vector3& target);
            void copyOrientation(const Quaternion& orient);
            void copyTargetOrientation();

            void spin();
            void turn180();
            void follow();
            void setTargetPosition(const Vector3& target);

            void setTargetOrientation(const Quaternion& orient);
            void setTargetOrientation(Pawn* target);



            void setTarget(Pawn* target);

            void searchNewTarget();
            void forgetTarget();

            void targetDied();
*/
            bool bHasTargetPosition_;
            Vector3 targetPosition_;
            bool bHasTargetOrientation_;
            Quaternion targetOrientation_;

            WeakPtr<ControllableEntity> target_;
            bool bShooting_;

            FormationMode formationMode_;



            //void defaultBehaviour(float maxrand); //<! Helper function for code reusage. Some concrete commands for a bot.    
         
        private:
            
            //Timer actionTimer_; //<! Regularly calls action().
               
    };
}

#endif /* _CommonController_H__ */
