/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDWeaponSystem_H__
#define _HUDWeaponSystem_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <vector>
#include <string>

#include "overlays/OrxonoxOverlay.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"
#include "HUDWeapon.h"

namespace orxonox
{
    class _OverlaysExport HUDWeaponSystem : public OrxonoxOverlay
    {
    public:
        HUDWeaponSystem(Context* context);
        virtual ~HUDWeaponSystem();

        virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
        virtual void changedOwner();
        virtual void changedOverlayGroup();
        virtual void changedVisibility();
        virtual void changedName();
        virtual void positionChanged();
        virtual void sizeChanged();
    protected:
        inline void setWeaponModeHUDSize(Vector2 vector)
            { weaponModeHUDSize_ = vector;
                this->setSize(weaponModeHUDSize_);
            }
        inline Vector2 getWeaponModeHUDSize() const
            { return weaponModeHUDSize_; }
    private:
        virtual void updateWeaponList();
        virtual void createHUDChilds();
        virtual void positionHUDChilds();
        virtual void destroyHUDChilds();

        WeakPtr<Pawn> owner_;

        std::vector<WeakPtr<Weapon> > weapons_;
        std::vector<WeakPtr<HUDWeapon> > hudWeapons_;

        Vector2 weaponModeHUDSize_;
        Vector2 weaponModeHUDActualSize_;
    };
}

#endif /* _HUDWeaponSystem_H__ */
