/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDWeapon_H__
#define _HUDWeapon_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <vector>
#include <string>

#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h> 

#include "overlays/OrxonoxOverlay.h"
#include "tools/interfaces/Tickable.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"
#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponMode.h"
#include "HUDWeaponMode.h"

namespace orxonox
{
    class _OverlaysExport HUDWeapon : public OrxonoxOverlay, public Tickable
    {
    public:
        HUDWeapon(Context* context);
        virtual ~HUDWeapon();

        virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
        virtual void tick(float dt);
        virtual void changedOwner();
        virtual void changedOverlayGroup();
        virtual void changedVisibility();
        virtual void changedName();
        virtual void positionChanged();
        virtual void sizeChanged();

        virtual void setWeapon(Weapon* weapon);

        inline void setWeaponModeHUDActualSize(Vector2 vector)
            { weaponModeHUDActualSize_ = vector;
              this->updateSize();
            }
        inline Vector2 getWeaponModeHUDActualSize() const
            { return weaponModeHUDActualSize_; }
        inline void setWeaponIndex(int index)
            { weaponIndex_ = index;
              this->updatePosition();
            }        

    private:
        virtual void createHUDChilds();
        virtual void positionHUDChilds();
        virtual void destroyHUDChilds();
        virtual void updateWeaponModeList();
        virtual void updateSize();
        virtual void updatePosition();

        WeakPtr<Pawn> owner_;
        WeakPtr<Weapon> weapon_;

        std::multimap<unsigned int, WeaponMode*>* weaponModes_;
        std::vector<WeakPtr<HUDWeaponMode> > hudWeaponModes_;

        Ogre::PanelOverlayElement* overlayElement_;

        Vector2 weaponModeHUDActualSize_;
        int weaponIndex_;
    };
}

#endif /* _HUDWeapon_H__ */
