/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "LeaderController.h"
#include "core/CoreIncludes.h"

#include "core/XMLPort.h"
#include "core/command/ConsoleCommandIncludes.h"

#include "worldentities/ControllableEntity.h"
#include "worldentities/pawns/Pawn.h"

namespace orxonox
{

    RegisterClass(LeaderController);

    static const int RADIUS_TO_SEARCH_FOR_LEADER = 3000;

    LeaderController::LeaderController(Context* context) : CommonController(context)
    {

        RegisterObject(LeaderController);
        bIsDivisionLeader_ = false;

        //this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&LeaderController::action, this)));
    }


    LeaderController::~LeaderController()
    {
    }

    LeaderController* LeaderController::findNewDivisionLeader()
    {

        if (!this->getControllableEntity())
            return NULL;

        
        //go through all pawns
        for (ObjectList<Pawn>::iterator it = ObjectList<Pawn>::begin(); it; ++it)
        {

            //same team?
            if (!(this->getControllableEntity()->getTeam() != static_cast<ControllableEntity*>(*it)->getTeam()))
                continue;

            //Does it have a Controller?
            Controller* controller = 0;

            if (it->getController())
                controller = it->getController();
            else if (it->getXMLController())
                controller = it->getXMLController();

            if (!controller)
                continue;

            //is equal to this?
            if (orxonox_cast<ControllableEntity*>(*it) == this->getControllableEntity())
                continue;


            LeaderController* newLeader = orxonox_cast<LeaderController*>(controller);

            //nullptr or not DivisionController?
            if (!newLeader || !newLeader->bIsDivisionLeader_)
                continue;

            float distance = (it->getPosition() - this->getControllableEntity()->getPosition()).length();

            // is pawn in range?
            if (distance < RADIUS_TO_SEARCH_FOR_LEADER)
            {

                if (newLeader->setFollower(this))
                    return newLeader;
            }
        }
                return NULL;

    }
    void LeaderController::action()
    {
        //this->target_ = this->sectionTarget_;        
        if (!myDivisionLeader_)
        {
            LeaderController* newDivisionLeader = findNewDivisionLeader();
            myDivisionLeader_ = newDivisionLeader;
            orxout(internal_error) << "new DivisionLeader set" << endl;
        }
    }
    /*
    Wingmen and Leaders attack target_, which is a member variable of their classes.
    Wingmen's target_ is set to sectionTarget_, which is a member variable of SectionController class, unless
    Wingman covers Leader's rear.
    Leader's target_ must always equal sectionTarget_.
    if section has a target, its Leader shoots at it, but doesn't follow.
    Every section is a part of division. Division consisting of one Section is still a division.
    Division's leader's target_ must always equal divisionTarget_, which is a member variable of DivisionController.
    Division leader ONLY can follow target_ while in formation flight.
    If Division doesn't have a target, Division Leader stays in place, unless it has a waypoint.
    Division Leader's sectionTarget_ must equal divisionTarget_,
    but the other section, that is not a leading section, can attack any target that is near divisonTarget_

    */
    void LeaderController::tick(float dt)
    {/*
        if (!this->isActive())
            return;
        
        //--------------------------Stay in division--------------------------
        this->keepDivisionTick();*/
        /*keepDivisionTick(){
            if (this->divisionLeader_ && this->divisionLeader_->getControllableEntity() && desiredRelativePosition_){
                Vector3 desiredAbsolutePosition = ((this->divisionLeader_->getControllableEntity()->getWorldPosition()) + 
                    (this->divisionLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
                this->moveToPosition (desiredAbsolutePosition);
            }
        }
        */
        /*//If ordered to attack -> follow target and shoot
        if (this->bAttackOrder_)
        {
 
        } 
        //If ordered to move -> move to a target Point
        
        //No orders -> Don't move, but shoot at whatever is close, unless Boss is shooting at it. 
        //(Section shoots same target, Boss's section shoots another target) 
        {

        }*/

        orxout(internal_error) << "my Wingman is " << this->myWingman_ << endl;
        
        SUPER(LeaderController, tick, dt);
    }
    bool LeaderController::setWingman(WingmanController* wingman)
    {
        if (!this->myWingman_)
        {
            this->myWingman_ = wingman;
            return true;
        }
        else
        {
            return false;
        }
    }
    bool LeaderController::isLeader()
    {
        return true;
    }
//**********************************************NEW
   /* void LeaderController::defaultBehaviour(float maxrand)
    {  
       
    }*/

}
