/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "WingmanController.h"

#include "core/CoreIncludes.h"

#include "core/XMLPort.h"
#include "core/command/ConsoleCommandIncludes.h"

#include "worldentities/ControllableEntity.h"
#include "worldentities/pawns/Pawn.h"

namespace orxonox
{

    RegisterClass(WingmanController);
    static const int RADIUS_TO_SEARCH_FOR_LEADER = 3000;

    WingmanController::WingmanController(Context* context) : CommonController(context)
    {
        RegisterObject(WingmanController);
        //this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&WingmanController::action, this)));
    }

    WingmanController::~WingmanController()
    {
    }

   /* void WingmanController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(WingmanController, XMLPort, xmlelement, mode);

        XMLPortParam(WingmanController, "accuracy", setAccuracy, getAccuracy, xmlelement, mode).defaultValues(100.0f);
        XMLPortObject(WingmanController, WorldEntity, "waypoints", addWaypoint, getWaypoint,  xmlelement, mode);
    }*/
    CommonController* WingmanController::findNewLeader()
    {

        if (!this->getControllableEntity())
            return NULL;

        
        //go through all pawns
        for (ObjectList<Pawn>::iterator it = ObjectList<Pawn>::begin(); it; ++it)
        {

            //same team?
            if (!(this->getControllableEntity()->getTeam() != static_cast<ControllableEntity*>(*it)->getTeam()))
                continue;

            //Does it have a Controller?
            Controller* controller = 0;

            if (it->getController())
                controller = it->getController();
            else if (it->getXMLController())
                controller = it->getXMLController();

            if (!controller)
                continue;

            //is equal to this?
            if (orxonox_cast<ControllableEntity*>(*it) == this->getControllableEntity())
                continue;


            CommonController* newLeader = orxonox_cast<CommonController*>(controller);

            //nullptr?
            if (!newLeader || !newLeader->isLeader())
                continue;

            float distance = (it->getPosition() - this->getControllableEntity()->getPosition()).length();

            // is pawn in range?
            if (distance < RADIUS_TO_SEARCH_FOR_LEADER)
            {

                if (newLeader->setWingman(this))
                    return newLeader;
            }
        }
        return NULL;
    }
    bool WingmanController::isLeader()
    {
        return false;
    }
    void WingmanController::action()
    {
        //this->target_ = this->sectionTarget_;
        if (!myLeader_)
        {
            CommonController* newLeader = findNewLeader();
            myLeader_ = newLeader;
            orxout(internal_error) << "new Leader set" << endl;
        }
    }

    void WingmanController::tick(float dt)
    {   
        //-------------------------------------------------------
            /*//collect data for AI behaviour
            Vector3* meanOfEnemiesPtr = new Vector3(0.0,0.0,0.0);
            Vector3* meanOfAlliesPtr  = new Vector3(0.0,0.0,0.0);
            Vector3 meanOfAllies = *meanOfAlliesPtr;
            Vector3 meanOfEnemies = *meanOfEnemiesPtr;


            for (ObjectList<AIController>::iterator it = ObjectList<AIController>::begin(); it; ++it)
            {

                Gametype* gt=this->getGametype();
                if (!gt)
                {
                    gt=it->getGametype();
                }
                if (!FormationController::sameTeam(this->getControllableEntity(), it->getControllableEntity(),gt))
                {
                    enemies_.push_back(*it);
                } 
                else {
                    allies_.push_back(*it);
                } 
            }
            if (enemies_.size() != 0 && allies_.size() != 0){
                for (std::vector<WeakPtr<AIController> >::iterator it = enemies_.begin() ; it != enemies_.end(); ++it)
                    meanOfEnemies += (*it)->getControllableEntity()->getWorldPosition();

                meanOfEnemies /= enemies_.size();

                for (std::vector<WeakPtr<AIController> >::iterator it = allies_.begin() ; it != allies_.end(); ++it)
                    meanOfAllies += (*it)->getControllableEntity()->getWorldPosition();

                meanOfAllies /= allies_.size();

                //orxout(internal_error) << "There are " << enemies_Counter << " enemies_, mean position is " << meanOfEnemies << endl;
                orxout(internal_error) << "Distance is " << (meanOfEnemies-meanOfAllies).length() << endl;
                orxout(internal_error) << "mean of allies_ is " << meanOfAllies << ", with a size " << allies_.size() << endl;
                orxout(internal_error) << "mean of enemies_ is " << meanOfEnemies << ", with a size " << enemies_.size() << endl;
            }*/
    /*
        if (!this->isActive())
            return;
        //--------------------------Stay in formation--------------------------
        if (bFollowLeader_)
        {
            this->keepSectionTick();*/
            /*keepSectionTick(){
                if (this->sectionLeader_ && this->sectionLeader_->getControllableEntity() && desiredRelativePosition_){
                    Vector3 desiredAbsolutePosition = ((this->sectionLeader_->getControllableEntity()->getWorldPosition()) + 
                        (this->sectionLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
                    this->moveToPosition (desiredAbsolutePosition);
                }
            }
            */
          /*  
            //--------------------------Attack same target as the Leader--------------------------

            if (this->target_)
            {
                this->aimAtTarget();
                this->doFire();
            }
        }*/
         //orxout(internal_error) << "I am " << this << endl;

       /* void FormationController::setDesiredPositionOfSlaves()
    {
        if (this->state_ != MASTER)
            return;
        switch (this->formationMode_){
            case ATTACK:
            {
                float i = 0;
                for(std::vector<FormationController*>::iterator it = slaves_.begin(); it != slaves_.end(); it++)
                {
                    (*it)->desiredRelativePosition_ = new Vector3 ((i-slaves_.size()/2)*200, 0, 0);
                    i++;
                }
                break;
            }
            case NORMAL: 
            {
                break;
            }
            case DEFEND: 
            {
                break;
            }
        }
       
    }*/
        
        SUPER(WingmanController, tick, dt);
    }
//**********************************************NEW
    /*void WingmanController::defaultBehaviour(float maxrand)
    {  
       
    }*/

}
