/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _FleetController_H__
#define _FleetController_H__
#include "controllers/FormationController.h"

#include "controllers/Controller.h"
#include "controllers/DivisionController.h"
#include "controllers/LeaderController.h"
#include "controllers/WingmanController.h"

#include "OrxonoxPrereqs.h"
#include "core/class/Super.h"
#include "core/CoreIncludes.h"


#include <vector>
#include "util/Math.h"
#include <climits>

#include "tools/Timer.h"
#include "tools/interfaces/Tickable.h"

#include "worldentities/ControllableEntity.h"
#include "worldentities/pawns/SpaceShip.h"
#include "worldentities/pawns/Pawn.h"
#include "worldentities/pawns/TeamBaseMatchBase.h"



namespace orxonox
{   

    class _OrxonoxExport FleetController : public FormationController, public Tickable
    {
        public:
          FleetController(Context* context);
          virtual ~FleetController();

          virtual void tick(float dt); //<! Carrying out the targets set in action().

          virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

          //gameGoal_ is to be set in XML
          //DOMINATE is default, makes AI want to be the only team alive
          //MOVE makes a fleet move to a set absolute position (set in variable goalPosition_)
          //DESTROY makes a fleet destroy a target (set in variable goalTarget_)
          //PROTECT makes a fleet protect a target (set in variable goalProtect_)
          enum GameGoal {DOMINATE, MOVE, DESTROY, PROTECT};
          
          


        protected:

            
            GameGoal gameGoal_;
            Vector3* goalPosition_;
            WeakPtr<Pawn> goalTarget_;
            WeakPtr<Pawn> goalProtect_;

            virtual void action();
        private:
            int nTicks_;
            bool bTicked_;

            std::vector<WeakPtr<DivisionController> > divisions_;
            //Timer actionTimer_; //<! Regularly calls action().

    };
}

#endif /* _FleetController_H__ */
