/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "FleetController.h"


namespace orxonox
{

    RegisterClass(FleetController);

    FleetController::FleetController(Context* context) : FormationController(context)
    {
        RegisterObject(FleetController);
        
        this->gameGoal_ = DOMINATE;
        this->goalPosition_ = NULL;
        this->goalTarget_ = NULL;
        this->goalProtect_ = NULL;
        this->nTicks_ = 0;
        this->bTicked_ = false;
        //this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&FleetController::action, this)));
    }

    FleetController::~FleetController()
    {
        if (this->isInitialized())
        {
           
        }
    }
    void FleetController::action()
    {


    }
    void FleetController::tick(float dt)
    {

         if (nTicks_ == 30)
         {
            std::vector<WeakPtr<WingmanController> > wingmen;
            std::vector<WeakPtr<LeaderController> > leaders;

            //--------------------------Put all WingmanController's in a vector--------------------------
            for (ObjectList<WingmanController>::iterator it = ObjectList<WingmanController>::begin(); it; ++it)
            {

               
                if ((*it)->getTeam() == this->getTeam())
                {
                    orxout(internal_error) << "ANOTHER SUCKER" << endl;
                    wingmen.push_back(*it);
                } 
                
            }
            //--------------------------Substitute half of WingmanController's with LeaderController--------------------------

            bool nowLeader = true;
            LeaderController* leader;

            for (std::vector<WeakPtr<WingmanController> >::iterator it = wingmen.begin() ; it != wingmen.end(); ++it)
            {
                if (nowLeader)
                {
                    leader = new LeaderController(this->getContext());
                    leader->setTeam(this->team_);

                    (*it)->getControllableEntity()->setController(leader);
                    leaders.push_back(leader);
                    nowLeader = !nowLeader;
                    orxout(internal_error) << "NEW SUCKER" << endl;

                }
                else
                {
                    if (leader)
                    {
                        leader->setWingman(*it);
                        nowLeader = !nowLeader;
                        orxout(internal_error) << "I OWN THE SUCKER" << endl;

                    }
                }
            }

            //--------------------------Substitute half of LeaderController's with DivisionController--------------------------
            bool nowDivision = true;
            DivisionController* division;

            for (std::vector<WeakPtr<LeaderController> >::iterator it = leaders.begin() ; it != leaders.end(); ++it)
            {
                if (nowDivision)
                {
                    division = new DivisionController(this->getContext());
                    division->setTeam(this->team_);

                    (*it)->getControllableEntity()->setController(division);

                    divisions_.push_back(division);

                    nowDivision = !nowDivision;
                }
                else
                {
                    if (division)
                    {
                        division->setLeader(*it);
                        nowDivision = !nowDivision;
                    }
                }
            }
            bTicked_ = true;
            nTicks_ += 1;
         }
         else if (!bTicked_)
         {
            nTicks_ += 1;

         }
        SUPER(FleetController, tick, dt);

    }
    void FleetController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(FleetController, XMLPort, xmlelement, mode);

        //XMLPortObject(FleetController, GameGoal, "gameGoal", setGameGoal, getGameGoal, xmlelement, mode).defaultValues(DOMINATE);
        //XMLPortParam(FleetController, "goalPosition", setGoalPosition, getGoalPosition, xmlelement, mode).defaultValues(NULL);
        //XMLPortParam(FleetController, "goalTarget", setGoalTarget, getGoalTarget, xmlelement, mode).defaultValues(NULL);
        //XMLPortParam(FleetController, "goalProtect", setGoalProtect, getGoalProtect, xmlelement, mode).defaultValues(NULL);

    }

    
   

}
