/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _DivisionController_H__
#define _DivisionController_H__

#include "controllers/LeaderController.h"



namespace orxonox
{
    class _OrxonoxExport DivisionController : public LeaderController
    {
        public:
        	DivisionController(Context* context);
        	virtual ~DivisionController();

        	//virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

        	//Using british military aircraft formations
        	enum FormationMode {VEE,FINGER4,DIAMOND, WALL};
        	void setFormationMode(FormationMode val);
     		inline FormationMode getFormationMode() const
           		{ return this->formationMode_; }
			virtual void setLeader(LeaderController* leader);

			

        protected:

	     	//Target enemy, set by fleet controller.
	        WeakPtr<Pawn> target_;
	        bool bHasTargetPosition_;
			Vector3 targetPosition_;
			bool bHasTargetOrientation_;
			Quaternion targetOrientation_;
			FormationMode formationMode_;
			
			/*void setTargetPosition(const Vector3& target);
			void searchRandomTargetPosition();

			void setTargetOrientation(const Quaternion& orient);
			void setTargetOrientation(Pawn* target);

			virtual void positionReached() {}



			void setTarget(Pawn* target);

			void searchNewTarget();
		    void forgetTarget();

			void targetDied();
			bool bShooting_;
			void aimAtTarget();

            bool isCloseAtTarget(float distance) const;
            bool isLookingAtTarget(float angle) const;

	        //Has nothing to do with desiredRelativePosition_,
	        //is set by fleet controller.
	        Vector3* desiredAbsolutePosition_;

    		enum Maneuver {NONE, SPIN, TURN180};
    		Maneuver maneuver_;

    		void moveToPosition(const Vector3& target);
		    void moveToTargetPosition();
		    void absoluteMoveToPosition(const Vector3& target);
		    void copyOrientation(const Quaternion& orient);
		    void copyTargetOrientation();

			void turn180Init();
		    void spinInit();
		    void spin();
      		void turn180();*/

      		LeaderController* leader_;
	        

	    
        private:
    };
}

#endif /* _DivisionController_H__ */
