/*!
 * @file explosion.h
 * @brief a Explosion Projectile
*/

#ifndef _EXPLOSION_H
#define _EXPLOSION_H

#include "world_entity.h"
#include "sound_source.h"
#include "sound_buffer.h"
#include "sound/resource_sound_buffer.h"

class SpriteParticles;
class BoxEmitter;
class FastFactory;

class Explosion : public WorldEntity
{
  ObjectListDeclaration(Explosion);
  public:
    static void explode (PNode* position, const Vector& size);
    void explode (float x, float y, float z); /// Explode at the current position with size (x,y,z)
    void setExplosionSound(const std::string& newExplosionSound){  this->explosionSoundBuffer = OrxSound::ResourceSoundBuffer(newExplosionSound);  }
    
    Explosion ();
    virtual ~Explosion ();

    virtual void activate();
    virtual void deactivate();

    virtual void tick (float time);

  private:
    static FastFactory*        fastFactory;

    float                      lifeTime;
    float                      lifeCycle;

    static SpriteParticles*    explosionParticles;
    BoxEmitter*                emitter;
    
    OrxSound::SoundSource      explosionSound;
    OrxSound::SoundBuffer      explosionSoundBuffer;
};

#endif /* _EXPLOSION_H */
