/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "explosion.h"

#include "loading/fast_factory.h"

#include "state.h"

#include "particles/box_emitter.h"
#include "particles/sprite_particles.h"

#include "sound/resource_sound_buffer.h"
#include "sound_engine.h"


ObjectListDefinition(Explosion);
CREATE_FAST_FACTORY_STATIC(Explosion);

#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(Explosion,
                        // Coordinates
                            addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                            ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                            ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
                            ->addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                            ->addMethod("setAbsDir", Executor4<PNode, lua_State*,float,float,float,float>(&PNode::setAbsDir))
                        //Explode !
                            ->addMethod("explode", Executor3<Explosion, lua_State*, float, float, float>(&Explosion::explode))
                            ->addMethod("setExplosionSound", Executor1<Explosion, lua_State*, const std::string&>(&Explosion::setExplosionSound))
                       );

/**
 *  standard constructor
*/
Explosion::Explosion ()
{
  this->registerObject(this, Explosion::_objectList);
  this->toList(OM_DEAD_TICK);

  this->emitter = new BoxEmitter(Vector(10,10,10), 200, 45, M_2_PI);
  this->emitter->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);

  this->lifeCycle = 0.0f;
  this->lifeTime = .5f;
  
  this->explosionSound.setSourceNode(this);
  
}


/**
 *  standard deconstructor
*/
Explosion::~Explosion ()
{
  delete this->emitter;
  if (this->explosionSound.isPlaying())
    this->explosionSound.stop();
  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (Explosion::explosionParticles != NULL && Explosion::objectList().size() <= 1)
     Explosion::explosionParticles = NULL;
}

SpriteParticles* Explosion::explosionParticles = NULL;

void Explosion::explode(PNode* position, const Vector& size)
{
  Explosion* explosion = dynamic_cast<Explosion*>(Explosion::fastFactory->resurrect());
  explosion->setAbsCoor(position->getAbsCoor());
  explosion->emitter->setSize(size);
  explosion->activate();
}


void Explosion::explode(float x, float y, float z)
{
  Explosion* explosion = dynamic_cast<Explosion*>(Explosion::fastFactory->resurrect());
  explosion->setAbsCoor(this->getAbsCoor());
  explosion->emitter->setSize(Vector(x,y,z));
  explosion->activate();
  
  
}


void Explosion::activate()
{
  if (unlikely(Explosion::explosionParticles == NULL))
  {
    Explosion::explosionParticles = new SpriteParticles(5000);
    Explosion::explosionParticles->setName("ExplosionExplosionParticles");
    Explosion::explosionParticles->setMaterialTexture("textures/radial-trans-noise.png");
    Explosion::explosionParticles->setLifeSpan(1.5, .3);
    Explosion::explosionParticles->setRadius(0.0, 10);
    Explosion::explosionParticles->setRadius(.5, 30.0);
    Explosion::explosionParticles->setRadius(1.0, 10.0);
    Explosion::explosionParticles->setColor(0.0, 1,0,0,1);
    Explosion::explosionParticles->setColor(0.5, .8,.8,0,.5);
    Explosion::explosionParticles->setColor(0.8, .8,.8,.3,.3);
    Explosion::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(Explosion::explosionParticles);
  this->emitter->updateNode(.01);
  this->emitter->updateNode(.01);
  this->toList(OM_DEAD_TICK);
  this->lifeCycle = 0.0;
  
  this->explosionSound.play(this->explosionSoundBuffer, OrxSound::SoundEngine::getInstance()->getEffectsVolume(), 0.01, true);
}


void Explosion::deactivate()
{
  this->emitter->setSystem(NULL);
  this->toList(OM_DEAD);
  Explosion::fastFactory->kill(this);
}


/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void Explosion::tick (float dt)
{
  this->lifeCycle += dt;
  if(this->lifeTime < this->lifeCycle)
    this->deactivate();
}
