/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverShip.cc
    @brief Implementation of the HoverShip class.
*/

#include "HoverShip.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(HoverShip);

    HoverShip::HoverShip(Context* context) : SpaceShip(context)
    {
        RegisterObject(HoverShip);
    }

    void HoverShip::tick(float dt)
    {
        SUPER(HoverShip, tick, dt);
    }

    void HoverShip::moveFrontBack(const Vector2& value)
                { this->steering_.z -= value.x; }

    void HoverShip::moveRightLeft(const Vector2& value)
        { this->steering_.x += value.x; }

    void HoverShip::moveUpDown(const Vector2& value)
        { this->steering_.y += value.x; }

    void HoverShip::rotateYaw(const Vector2& value) {}
    void HoverShip::rotatePitch(const Vector2& value) {}
    void HoverShip::rotateRoll(const Vector2& value) {}

    bool HoverShip::collidesAgainst(WorldEntity* otherObject, btManifoldPoint& contactPoint)
    {
        /*if (contactPoint.m_normalWorldOnB.y() > 0.6)
            this->isFloor_ = true;
        else
            this->isFloor_ = false;

        return false;*/
        return false;
    }

    void HoverShip::boost(bool bBoost) {
        /*if (this->isFloor_)
        {
            if (!this->thisTickBoost_)
                this->localVelocity_.y = jumpValue_;
            //this->physicalBody_->applyCentralImpulse(btVector3(0, jumpvalue, 0));
            this->thisTickBoost_ = true;
            this->isFloor_ = false;
        }*/
    }

   /* Hover* HoverShip::getGame()
    {
        if (game == NULL)
        {
            for (ObjectList<Hover>::iterator it = ObjectList<Hover>::begin(); it != ObjectList<Hover>::end(); ++it)
            {
                game = *it;
            }
        }
        return game;
    }*/
}
