/*
* file bsp_weapon.h
* A weapon that shoots both at player and environment (pnode and bsp).
*/

#ifndef _BSP_WEAPON_H
#define _BSP_WEAPON_H

#include "world_entity.h"
#include "aiming_system.h"

class BspWeapon : public WorldEntity
	{
		ObjectListDeclaration(BspWeapon);
	public:
		BspWeapon ();
		BspWeapon (const  TiXmlElement* root);
		virtual ~BspWeapon();

		void init();
		void loadParams(const TiXmlElement* root);
		void fire(bool fire){ bFire = fire; }
		virtual void tick(float dt);
		virtual void draw() const;


	private:

		void shoot();
		float range;
		void setRange( float r ){ this->range = r; }
		float damage;
		void setDamage( float d ){ this->damage = d; }
		float fireRate;
		void setFireRate( float r ){ this->fireRate = r; }
		bool alwaysHits;
		void setAlwaysHits( bool r ){ this->alwaysHits = r; }

		float bRate;
		bool bFire;

		AimingSystem* aimingSystem;
	};

#endif
