/*
* orxonox - the future of 3D-vertical-scrollers
*
* Copyright (C) 2004 orx
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
*     ### File Specific:
*     main-programmer: Reto Luechinger
*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY
#include "bsp_weapon.h"
#include "loading/load_param.h"
#include "debug.h"
#include "loading/load_param_xml.h"

#include "environments/bsp_entity.h"

ObjectListDefinition(BspWeapon);
CREATE_FACTORY(BspWeapon);

/**
*  Standard constructor
*/
BspWeapon::BspWeapon ()
{
	this->init();
}

/**
* destructs the BspWeapon, deletes allocated memory
*/
BspWeapon::~BspWeapon ()
{
          // will be deleted
}

/**
* Constructor with XML Element
*/
BspWeapon::BspWeapon (const  TiXmlElement* root)
{
	this->init();
	if (root != NULL)
        {
		this->loadParams(root);
	}
}
/**
* XML Loader
*/
void BspWeapon::loadParams(const TiXmlElement* root)
{
	if (root != NULL)
	{
		WorldEntity::loadParams(root);

		LoadParam(root, "Range", this, BspWeapon, setRange)
			.describe("the range after which the Weapon hits no more")
		.defaultValues("");
                LoadParam(root, "Damage", this, BspWeapon, setDamage)
                        .describe("Damage that the weapon inflicts"); 
		LoadParam(root, "FireRate", this, BspWeapon, setFireRate)
  			.describe("how fast it shoots");
		LoadParam(root, "AlwaysHits", this, BspWeapon, setAlwaysHits)
  			.describe("No, if the weapon should hit with a probability");
	}
}

	

void BspWeapon::tick( float dt )
{
	if (bFire) {
		if (bRate < 0) {
			bRate += fireRate;
			this->shoot();
		}
		else {
			bRate = bRate - dt;
		}	
	}
	else {
		bRate -= dt;
		if (bRate < 0)
			bRate = 0;
	}
}

void BspWeapon::init()
{
	bRate = 0;
	bFire = true;
	range = 1000;
	damage = 10;
	fireRate = 0.5;
	alwaysHits = true;

	this->registerObject(this, BspWeapon::_objectList);
	this->aimingSystem = new AimingSystem( this );
	this->aimingSystem->setParent( this );
	this->aimingSystem->toList(OM_GROUP_00);
}

void BspWeapon::shoot()
{
	std::list<WorldEntity*>::iterator entityIterator;
	// for all bsp managers check all entities
	Vector pos = this->getAbsCoor();
	Vector dir = pos + this->getAbsDir().apply( Vector( 1, 0, 0 ) )*range;
	
	
	float shortestDist = range;
	for( ObjectList<BspEntity>::const_iterator bspIterator = BspEntity::objectList().begin();
		bspIterator != BspEntity::objectList().end();
		bspIterator++) {
		float res = (dynamic_cast<BspEntity*>(*bspIterator)->getBspManager())->checkCollisionRay( pos, dir, dir.len() + 1 );
	
		if ( res < shortestDist )
			shortestDist = res;
	}

	WorldEntity* target = aimingSystem->getNearestTarget();
	aimingSystem->flushList();

	bool hit = false;

	if ( target == NULL )
		printf("NOTING HIT\n");
	else
	{
		printf( "HIT %s\n", target->getClassName().c_str() );

		if (!alwaysHits){
			float r = rand();
			r = r/RAND_MAX;
			float res = (target->getAbsCoor() - this->getAbsCoor()).len();
			float p = 1 - res*res/range/range;
			if (r < p )
				hit = true;
		}
		else hit = true;
	}

	if ( !hit )
	{
		Vector explosionPos = this->getAbsCoor() + this->getAbsDir().apply( Vector( 1, 0, 0 ) )*shortestDist;

		//TODO create explosion at explosionPos
	}

	
}

void BspWeapon::draw() const
{
  WorldEntity::draw();


  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  glPushAttrib(GL_ENABLE_BIT);

  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glLineWidth(2.0);


  Vector mp = this->getAbsCoor();
  Vector op = this->getAbsDir().apply( Vector(1, 0, 0) );
  op *= 100;
  op += mp;

  glColor3f(1.0, 1.0, 1.0 );
  glBegin(GL_LINE_STRIP);
    glVertex3f(mp.x, mp.y, mp.z);
    glVertex3f(op.x, op.y, op.z);
  glEnd();

  
  glPopAttrib();
  glPopMatrix();
  
}
