  /*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "aiming_system.h"

#include "util/loading/load_param.h"

#include "state.h"
#include "debug.h"

#include "aabb.h"
#include "obb_tree.h"



ObjectListDefinition(AimingSystem);

/**
 * standart constructor
 */
AimingSystem::AimingSystem (WorldEntity* entity)
  : WorldEntity()
{
  this->owner = entity;

  this->init();
}


/**
 * destroys a AimingSystem
*/
AimingSystem::~AimingSystem ()
{}


/**
 * initializes the AimingSystem
 */
void AimingSystem::init()
{
  this->registerObject(this, AimingSystem::_objectList);
  this->setName("AimingSystem");

  //this->loadModel("models/guns/targeting_system_body2.obj");
//   this->loadModel("models/ships/fighter.obj");

  // registering default reactions:
  this->unsubscribeReaction(CoRe::CREngine::CR_OBJECT_DAMAGE);
  this->subscribeReaction(CoRe::CREngine::CR_OBJECT_DAMAGE, WorldEntity::staticClassID());

  this->range = 1000.0f;
  this->sideLength = 2.0f;

  // new obb tree
  this->obbTree = new OBBTree();
  this->obbTree->createBox(Vector(0.0f, 0.0f, 0.0f), Vector(this->range, this->sideLength, this->sideLength));
  this->setOBBTree(this->obbTree);
}



/**
 * get back the nearest target
 * @returns the nerest target
 */
WorldEntity* AimingSystem::getNearestTarget()
{
  if( this->selectionList.size() == 0)
    return NULL;


  WorldEntity* nearestEntity     = NULL;
  float        distance          = 0.0f;
  float        smalestDistance   = this->range * 5.0f;


  for(unsigned int i = 0; i < this->selectionList.size(); i++)
  {
    distance = fabs((this->getAbsCoor() - this->selectionList[i]->getAbsCoor()).len());
    if( distance < smalestDistance)
    {
      nearestEntity = this->selectionList[i];
      smalestDistance = distance;
    }
  }

  PRINTF(0)("entity: %s\n", nearestEntity->getClassCName());
    return nearestEntity;
}


/**
 * called when an object is "selected"
 *  @param damage damage to be dealt
 *  @param killer the entity
 */
void AimingSystem::hit(float damage, WorldEntity* killer)
{
  if( this->owner != killer && killer != this && !killer->isA( AimingSystem::staticClassID() ) )
  {
    //PRINTF(0)("real hit: %s\n", killer->getClassCName());
    this->selectionList.push_back(killer);
  }
}



/**
 * ticks the AimingSystem
 * @param dt the time to ticks
 */
void AimingSystem::tick(float dt)
{
}


/**
 * draws the crosshair
 */
void AimingSystem::draw() const
{
  WorldEntity::draw();

//   glMatrixMode(GL_MODELVIEW);
//   glPushMatrix();
//
//   /* translate */
//   glTranslatef (this->getAbsCoor ().x,
//                 this->getAbsCoor ().y,
//                 this->getAbsCoor ().z);
//   Vector tmpRot = this->getAbsDir().getSpacialAxis();
//   glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
//
//   this->obbTree->drawBV(0, 1);
//
//   glPopMatrix();

}
