/*
* file groundTurret.h
* A weapon that is fix located, and automatically shooting at a target.
*/

#ifndef _ADM_TURRET_H
#define _ADM_TURRET_H

//#include "sound_buffer.h"
//#include "sound_source.h"

#include "world_entity.h"
#include "weapons/bsp_weapon.h"

class AdmTurret : public WorldEntity
      {
                   ObjectListDeclaration(AdmTurret);
      public:
                   AdmTurret ();
                   AdmTurret (const  TiXmlElement* root);
                   virtual ~AdmTurret();
                   
                   void init();
                   void loadParams(const TiXmlElement* root);
                   
                   virtual void tick(float dt);
                   virtual void draw() const;
                   virtual void collidesWith(WorldEntity* entity, const Vector& location);
                   
                   virtual void activate();
                   virtual void deactivate();
                   
                   virtual void setTarget(const std::string& target);
                   
      private:
                   WorldEntity* cannons;
                   WorldEntity* sensor;
                   WorldEntity* myTarget;
                   void fire();

		   void addCannons(const TiXmlElement* root);
		   void addSensor(const TiXmlElement* root);

		   void moveTowards( Vector targetDir, float dt );
                   
                   float bodyAngle;
                   float cannonAngle;
                   
                   bool isActive;
                   float range;
                   
                   bool isCeil;
                   void setType( const std::string& type );
                   
                   bool bFire;
                   bool playerVisible;
                   void updatePlayerVisible();

		BspWeapon* weapon;
      };

#endif
