/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "WingmanController.h"


namespace orxonox
{
    const float WingmanController::ACTION_INTERVAL = 1.0f;

    RegisterClass(WingmanController);

    WingmanController::WingmanController(Context* context) : SectionController(context)
    {
        RegisterObject(WingmanController);
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&WingmanController::action, this)));
    }

    WingmanController::~WingmanController()
    {
    }

   /* void WingmanController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(WingmanController, XMLPort, xmlelement, mode);

        XMLPortParam(WingmanController, "accuracy", setAccuracy, getAccuracy, xmlelement, mode).defaultValues(100.0f);
        XMLPortObject(WingmanController, WorldEntity, "waypoints", addWaypoint, getWaypoint,  xmlelement, mode);
    }*/
    void WingmanController::action()
    {
        //--------------------------Cover Leader's rear--------------------------
        //check for enemies in Leader's rear that can attack him and if they are visible, meaning there are no other Leader's between Leader and enemies.
        //if there are enemies, set target_ to the nearest one and set bFollowLeader_ to false, 
        //otherwise set bFollowLeader_ to true and target_ to sectionTarget_
        this->coverAllyRear(this->sectionLeader_);
    }

    void WingmanController::tick(float dt)
    {
        if (!this->isActive())
            return;
        //--------------------------Stay in formation--------------------------
        if (bFollowLeader_)
        {
            this->keepSectionTick();
            /*keepSectionTick(){
                if (this->sectionLeader_ && this->sectionLeader_->getControllableEntity() && desiredRelativePosition_){
                    Vector3 desiredAbsolutePosition = ((this->sectionLeader_->getControllableEntity()->getWorldPosition()) + 
                        (this->sectionLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
                    this->moveToPosition (desiredAbsolutePosition);
                }
            }
            */
            
            //--------------------------Attack same target as the Leader--------------------------
           
            if (this->target_)
            {
                this->aimAtTarget();
                this->doFire();
            }
        }
        //--------------------------Protect Leader by killing target_--------------------------

        else
        {
            if (this->target_)
            {
                //--------------------------Don't attack if not visible--------------------------                
                if (!this->target_->getRadarVisibility()) /* So AI won't shoot invisible Spaceships */
                {
                    this->forgetTarget();
                    //this->bFollowLeader_ = true;
                }
                //--------------------------Otherwise destroy it--------------------------
                else
                {
                    this->aimAtTarget();
                    this->follow();  //If a bot is shooting a player, it shouldn't let him go away easily.
                }
                if (this->bHasTargetPosition_)
                {
                    this->moveToTargetPosition();
                }
                this->doFire();
            }
            //--------------------------no target? do nothing until next action() -> either new target appears or bFollowLeader_ set to true--------------------------
            else
            {

            }            

        }
        SUPER(WingmanController, tick, dt);
    }
//**********************************************NEW
    /*void WingmanController::defaultBehaviour(float maxrand)
    {  
       
    }*/

}
