/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "LeaderController.h"



namespace orxonox
{
    const float LeaderController::ACTION_INTERVAL = 1.0f;

    RegisterClass(LeaderController);

    LeaderController::LeaderController(Context* context) : SectionController(context)
    {
        RegisterObject(LeaderController);
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&LeaderController::action, this)));
    }

    LeaderController::~LeaderController()
    {
    }

    void LeaderController::action()
    {
        
    }
    /*
    Wingmen and Leaders attack target_, which is a member variable of their classes.
    Wingmen's target_ is set to sectionTarget_, which is a member variable of SectionController class, unless
    Wingman covers Leader's rear.
    Leader's target_ must always equal sectionTarget_.
    if section has a target, its Leader shoots at it, but doesn't follow.
    Every section is a part of division. Division consisting of one Section is still a division.
    Division's leader's target_ must always equal divisionTarget_, which is a member variable of DivisionController.
    Division leader ONLY can follow target_ while in formation flight.
    If Division doesn't have a target, Division Leader stays in place, unless it has a waypoint.
    Division Leader's sectionTarget_ must equal divisionTarget_,
    but the other section, that is not a leading section, can attack any target that is near divisonTarget_

    */
    void LeaderController::tick(float dt)
    {
        if (!this->isActive())
            return;
        
        //--------------------------Stay in division--------------------------
        this->keepDivisionTick();
        /*keepDivisionTick(){
            if (this->divisionLeader_ && this->divisionLeader_->getControllableEntity() && desiredRelativePosition_){
                Vector3 desiredAbsolutePosition = ((this->divisionLeader_->getControllableEntity()->getWorldPosition()) + 
                    (this->divisionLeader_->getControllableEntity()->getWorldOrientation()* (*desiredRelativePosition_)));
                this->moveToPosition (desiredAbsolutePosition);
            }
        }
        */
        //If ordered to attack -> follow target and shoot
        if (this->bAttackOrder_)
        {

        } 
        //If ordered to move -> move to a target Point
        else if (this->bMoveOrder_)
        {

        } 
        else
        //No orders -> Don't move, but shoot at whatever is close, unless Boss is shooting at it. 
        //(Section shoots same target, Boss's section shoots another target) 
        {

        }


        SUPER(LeaderController, tick, dt);
    }
//**********************************************NEW
   /* void LeaderController::defaultBehaviour(float maxrand)
    {  
       
    }*/

}
