/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _SectionController_H__
#define _SectionController_H__

#include "controllers/DivisionController.h"


namespace orxonox
{
    class _OrxonoxExport SectionController : public DivisionController
    {
        public:
            SectionController(Context* context);
            virtual ~SectionController();

            //virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);



        protected:
      
            //A division is the biggest block of spaceships.
            //In division one section is leading, the other one always stays on the same position
            //relative to the Leader of the leading section.
            //In section a Wingman always stays on same position relative to the Leader.
            //That position is desiredRelativePosition_
            Vector3* desiredRelativePosition_;
            


            LeaderController* leader_;
            WingmanController* wingman_;
        
        private:
    };
}

#endif /* _SectionController_H__ */
