/*!
 * @file weapon_slot.h
 */


#ifndef _WEAPON_SLOT_H
#define _WEAPON_SLOT_H

#include "p_node.h"
#include "weapon.h"
#include "weapon_manager.h"

class Weapon;

//! a class defining a Slot, where a Weapon can be stored inside.
class WeaponSlot : public PNode
{
  ObjectListDeclaration(WeaponSlot);

public:

  WeaponSlot();
  WeaponSlot(const TiXmlElement* root);
  virtual ~WeaponSlot();

  virtual void loadParams(const TiXmlElement* root);

  void setWeaponClass();

  long getCapability() { return this->capability; }
  void setCapability(long cap) { this->capability = cap; }

  inline Weapon* getCurrentWeapon() { return this->currentWeapon; }
  inline void setCurrentWeapon(int config) { this->currentWeapon = this->configs[config]; }

  inline Weapon* getNextWeapon() { return this->nextWeapon; }
  inline void setNextWeapon(int config) { if (config == -1) this->nextWeapon = NULL; else this->nextWeapon = configs[config]; }

  inline void setNextToCurrent() {this->currentWeapon = this->nextWeapon; };
//   inline void setNextWeapon(const std::string& weaponName){this->nextWeapon = Weapon::createWeapon(weaponName); };
//   inline void setCurrentWeapon(const std::string& weaponName){ this->currentWeapon = Weapon::createWeapon(weaponName); };

  inline void addWeapon(const std::string& weaponName, int config) {this->configs[config] = Weapon::createWeapon(weaponName); }
  inline void setWeapon(Weapon* weapon, int config) {this->configs[config] = weapon; };
  inline Weapon* getWeapon(int config) { if (config > WM_MAX_CONFIGS) return NULL; return this->configs[config]; };

  inline void setWeaponConfig(int slot, int side) { this->weaponSlot = slot; this->weaponSide = side; }
  inline int getWeaponSlot() { return this->weaponSlot; }
  inline int getWeaponSide() { return this->weaponSide; }

  void removeWeapon(Weapon* weapon);

private:

  int           weaponSlot;
  int           weaponSide;

  long          capability;             //!< the capabilities of the Slot @see WeaponSlotCapability.

  Weapon*       configs[WM_MAX_CONFIGS];

  Weapon*       currentWeapon;          //!< The current weapon this slot is carrying.
  Weapon*       nextWeapon;             //!< either NULL or the next weapon that will be set (require currentWeapon to deactivate)

//   int           currentConfig;
//   int           nextConfig;
};


#endif /* _WEAPON_SLOT_H */
