
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Nicolas Schlumberger
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "weapon_slot.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


ObjectListDefinition(WeaponSlot);
CREATE_FACTORY(WeaponSlot);



WeaponSlot::WeaponSlot()
{
  this->registerObject(this, WeaponSlot::_objectList);

  for (int i = 0; i < WM_MAX_CONFIGS; i++)
    this->configs[i] = NULL;
}

WeaponSlot::WeaponSlot(const TiXmlElement* root)
{
   this->registerObject(this, WeaponSlot::_objectList);

   if( root != NULL)
     this->loadParams( root);
}


WeaponSlot::~WeaponSlot()
{
}



void WeaponSlot::loadParams(const TiXmlElement* root)
{
  PNode::loadParams( root);

    // now check for the orx class to create
  LoadParam(root, "WeaponClass", this, WeaponSlot, setWeaponClass)
  .describe("Sets the class this mount points should host");

  LoadParam(root, "slot", this, WeaponSlot, setWeaponConfig)
  .describe("sets the weapon slot");

//   LoadParam(root, "currentWeapon", this, WeaponSlot, setCurrentWeapon)
//   .describe("creates and set next weapon");
// 
//   LoadParam(root, "nextWeapon", this, WeaponSlot, setNextWeapon)
//   .describe("creates and set next weapon");

  LoadParam(root, "addWeapon", this, WeaponSlot, addWeapon)
  .describe("create a new Weapon, and add it to config");
}




void WeaponSlot::setWeaponClass()
{
}

