/*!
 * @file weapon_slot.h
 */


#ifndef _WEAPON_SLOT_H
#define _WEAPON_SLOT_H

#include "p_node.h"
#include "weapon.h"

class Weapon;

//! a class defining a Slot, where a Weapon can be stored inside.
class WeaponSlot : public PNode
{
  ObjectListDeclaration(WeaponSlot);

public:

  WeaponSlot();
  WeaponSlot(const TiXmlElement* root);
  virtual ~WeaponSlot();

  virtual void loadParams(const TiXmlElement* root);

  void setWeaponClass();

  long getCapability() { return this->capability; }
  void setCapability(long cap) { this->capability = cap; }

  inline Weapon* getCurrentWeapon() { return this->currentWeapon; }
  inline void setCurrentWeapon(Weapon* weapon) { this->currentWeapon = weapon; }

  inline Weapon* getNextWeapon() { return this->nextWeapon; }
  inline void setNextWeapon(Weapon* weapon) { this->nextWeapon = weapon; }

  inline void setNextWeapon(const std::string& weaponName){this->nextWeapon = Weapon::createWeapon(weaponName); };
  inline void setCurrentWeapon(const std::string& weaponName){ this->currentWeapon = Weapon::createWeapon(weaponName); };


  inline void setWeaponConfig(int slot, int side) { this->weaponSlot = slot; this->weaponSide = side; }
  inline int getWeaponSlot() { return this->weaponSlot; }
  inline int getWeaponSide() { return this->weaponSide; }


private:

  int           weaponSlot;
  int           weaponSide;

  long          capability;             //!< the capabilities of the Slot @see WeaponSlotCapability.

  Weapon*       currentWeapon;          //!< The current weapon this slot is carrying.
  Weapon*       nextWeapon;             //!< either NULL or the next weapon that will be set (require currentWeapon to deactivate)
};


#endif /* _WEAPON_SLOT_H */
