
#ifndef _NPC_H
#define _NPC_H

#include "world_entity.h"
#include "world_entities/weapons/weapon_manager.h"
#include "track/action_box.h"

class ActionboxEnemy : public WorldEntity
{
  ObjectListDeclaration(ActionboxEnemy);

  public:
    ActionboxEnemy(const TiXmlElement* root = NULL);
    virtual ~ActionboxEnemy ();
  
    virtual void tick(float dt);
    virtual void draw() const;

    virtual void loadParams(const TiXmlElement* root);
   
  private:
    bool  isActive;
    float pitch;      // rotate angle around x-axix
    float dPitch;     // change pitch += dPitch*dt
    Quaternion qPitch;
    
    float acceleration;
    float maxSpeed;
    float speed;
    
    Quaternion myDir;
    Vector     myCoor;
    
    bool       bFire;
    
    Vector     escapePoint;
    bool       onEscape;
    
    void attackPlayer( ActionBox* box, float dt );
    void moveTowardsBox( ActionBox* box, float dt );
    void moveTowards( Vector targetPos, Vector targetDir, float dt );
};

#endif
