/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *   Co-authors:
 *      ...
 *
 */

/**
    @file Hover.h
    @brief Gametype.
    @ingroup Hover
*/

#ifndef _Hover_H__
#define _Hover_H__

#include "Hover/HoverPrereqs.h"

#include "HoverCenterPoint.h" // Necessary for WeakPointer??
//#include "HoverShip.h"        DO NOT include in Header. Will cause forward declaration issues

//#include "HoverHUDinfo.h"


#include "core/EventIncludes.h"
#include "core/command/Executor.h"
#include "core/config/ConfigValueIncludes.h"

#include "gamestates/GSLevel.h"
#include "chat/ChatManager.h"
#include <vector>

// ! HACK
#include "infos/PlayerInfo.h"

#include "core/command/ConsoleCommand.h"
#include "worldentities/BigExplosion.h"

#include "gametypes/Deathmatch.h"
#include "tools/Timer.h"

namespace orxonox
{

    class Hover : public GameType
    {
       public:
            Hover(Context* context);

            virtual void start();
            virtual void end();

            virtual void tick(float dt);

            void setCenterpoint(HoverCenterPoint* center)
                       { this->center_ = center; }


    };
}

#endif /* _Hover_H__ */
