/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer, Nicolas Schlumberger
   co-programmer:

*/

#include "heavy_blaster.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"

CREATE_FACTORY(HeavyBlaster);
// ObjectListDefinition(HeavyBlaster);



/**
 * Standard constructor
 */
HeavyBlaster::HeavyBlaster (int leftRight)
 : Weapon()
{
//     this->registerObject(this, HeavyBlaster::_objectList);

    this->init(leftRight);
}

HeavyBlaster::HeavyBlaster (const TiXmlElement* root = NULL)
 : Weapon()
{
//     this->registerObject(this, HeavyBlaster::_objectList);

    // TODO add leftRight to params
    this->init(0);
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
HeavyBlaster::~HeavyBlaster()
{
  for (int i = 0; i < this->getBarrels(); i++)
  {
   delete [] this->shootAnim[i];
   delete [] this->objComp[i];
  }
  delete [] this->emissionPoint;

   delete [] this->shootAnim;
   delete [] this->objComp;
/*
    for(int j = 0; j < this->getSegs(); j++)
    {
      delete this->shootAnim[i][j];
      delete this->objComp[i][j];
    }
    delete this->shootAnim[i];
    delete this->objComp[i];
    delete this->emissionPoint[i];
  }*/

//  this->deconstr();
     // model will be deleted from WorldEntity-destructor
}

void HeavyBlaster::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void HeavyBlaster::init(int leftRight)
{

  this->leftRight = leftRight;
  //this->registerObject(this, HeavyBlaster::_objectList);

//  this->model = (Model*)ResourceManager::getInstance()->load("models/guns/test_gun.obj", OBJ, RP_CAMPAIGN);

  this->loadModel("models/guns/frag_cannon2.obj", .4);


  this->setStateDuration(WS_SHOOTING, 0.5);   // 2 Schuss pro Sekunde
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
//   this->setActionSound(WA_ACTIVATE, "sounds/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("HBolt");
  this->prepareProjectiles(5);

  this->setBarrels(3);
  this->setSegs(2);
  this->activeBarrel = 0;



  this->objComp = new PNode**[this->getBarrels()];
  this->emissionPoint = new PNode*[this->getBarrels()];
  this->shootAnim = new Animation3D**[this->getBarrels()];
  for (int i = 0; i < this->getBarrels(); i++)
  {
    this->objComp[i] = new PNode* [this->getSegs()];
    this->emissionPoint[i] = new PNode;
    this->emissionPoint[i]->setParent(this);             //< One EmissionPoint, that is a PNode connected to the weapon. You can set this to the exitting point of the Projectiles
    this->emissionPoint[i]->setName("EmissionPoint");
    this->emissionPoint[i]->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
    this->shootAnim[i] = new Animation3D* [this->getSegs()];
    for(int j = 0; j < this->getSegs(); j++)
    {
      this->objComp[i][j] = new PNode;
      this->shootAnim[i][j] = new Animation3D(this->objComp[i][j]);
      this->shootAnim[i][j]->setInfinity(ANIM_INF_CONSTANT);
    }
  }

  if (this->leftRight == W_RIGHT)
  {
    this->emissionPoint[0]->setRelCoor(Vector(1.1, 0.14, 0.06));
    this->emissionPoint[1]->setRelCoor(Vector(1.1, -.06, 0.14));
    this->emissionPoint[2]->setRelCoor(Vector(1.1, 0.06, -.14));
  }
  else {
    this->emissionPoint[0]->setRelCoor(Vector(1.1, 0.14, -.06));
    this->emissionPoint[1]->setRelCoor(Vector(1.1, -.06, -.14));
    this->emissionPoint[2]->setRelCoor(Vector(1.1, 0.06, 0.14));
  }


  for (int i = 0; i < this->getBarrels(); i++){
    this->shootAnim[i][0]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.05, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][0]->addKeyFrame(Vector(-0.3, 0.0, 0.0), Quaternion(), 0.9, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][0]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.55, ANIM_LINEAR, ANIM_NULL);

    this->shootAnim[i][1]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.05, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][1]->addKeyFrame(Vector(-0.4, 0.0, 0.0), Quaternion(), 1.2, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][1]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.25, ANIM_LINEAR, ANIM_NULL);
  }

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void HeavyBlaster::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());
  pj->setParent(PNode::getNullParent());

  pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*130 + VECTOR_RAND(1));

  pj->setAbsCoor(this->emissionPoint[this->activeBarrel]->getAbsCoor());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();

  // initiate animation
  for (int i = 0; i < this->getSegs(); i++)
    this->shootAnim[this->activeBarrel][i]->replay();

  // switch barrel
  this->activeBarrel = (this->activeBarrel + 1) % this->getBarrels();
}

/**
 *  this activates the weapon
*/
void HeavyBlaster::activate()
{
}

/**
 *  this deactivates the weapon
*/
void HeavyBlaster::deactivate()
{
}


void HeavyBlaster::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  if (this->leftRight == W_LEFT)
    glScalef(1.0, 1.0, -1.0);

  static_cast<StaticModel*>(this->getModel())->draw(6);

  glPushMatrix();
    glTranslatef (this->objComp[0][0]->getAbsCoor().x, this->objComp[0][0]->getAbsCoor().y, this->objComp[0][0]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(2);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[1][0]->getAbsCoor().x, this->objComp[1][0]->getAbsCoor().y, this->objComp[1][0]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(3);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[2][0]->getAbsCoor().x, this->objComp[2][0]->getAbsCoor().y, this->objComp[2][0]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(1);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[0][1]->getAbsCoor().x, this->objComp[0][1]->getAbsCoor().y, this->objComp[0][1]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(4);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[1][1]->getAbsCoor().x, this->objComp[1][1]->getAbsCoor().y, this->objComp[1][1]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(5);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[2][1]->getAbsCoor().x, this->objComp[2][1]->getAbsCoor().y, this->objComp[2][1]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(0);
  glPopMatrix();

  glPopMatrix();
}

void HeavyBlaster::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_heavy_bolt.png");
    this->setEnergyWidgetInitialized(true);
  }
}
