/*!
 * @file action_box.h
 */

#ifndef _ACTION_BOX_H_
#define _ACTION_BOX_H_

#include "world_entity.h"
#include "plane.h"

class Track;

class ActionBox : public WorldEntity
{
  public:
    virtual void tick (float time);
    virtual void draw () const;
    
    ActionBox( Track* _track, float width_2, float height_2, float depth, float stretch );
    ~ActionBox();
    
       
    bool isPointInBox( const Vector& pos );
    
  private:
    void updatePlanes();
    
    float width_2;   //! width/2 of near plane
    float height_2;  //! height/2 of near plane
    float depth;     //! distance between near and far plane
    float stretch;   //! far plane will be stretched by this factor
    
    Track* track;
    
    Plane planes[6];  //! planes for collision. normale must point towards middle
};

#endif
