/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:  Nicolas Schlumberger
   co-programmer:

*/

#include "rf_cannon.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"

CREATE_FACTORY(RFCannon);
/**
 * Standard constructor
 */
RFCannon::RFCannon ()
 : Weapon()
{
    this->init();
}

RFCannon::RFCannon (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
RFCannon::~RFCannon()
{
  for (int i = 0; i < this->getBarrels(); i++)
    delete [] this->objComp[i];

  delete [] this->emissionPoint;
  delete [] this->objComp;
}

void RFCannon::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void RFCannon::init()
{

  this->loadModel("models/guns/rf_cannon.obj", 0.3);


  this->setStateDuration(WS_SHOOTING, 0.1);  // 10 Schuss pro Sekunde
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("LBolt");
  this->prepareProjectiles(100);

  this->setBarrels(4);
  this->setSegs(1);
  this->activeBarrel = 0;

  this->objComp = new PNode**[this->getBarrels()];
  this->emissionPoint = new PNode*[this->getBarrels()];
  for (int i = 0; i < this->getBarrels(); i++) {
    this->objComp[i] = new PNode* [this->getSegs()];
    this->emissionPoint[i] = new PNode;
    this->emissionPoint[i]->setParent(this);
    this->emissionPoint[i]->setName("EmissionPoint");
    this->emissionPoint[i]->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
    for(int j = 0; j < this->getSegs(); j++) {
      this->objComp[i][j] = new PNode;
    }
  }

  this->emissionPoint[0]->setRelCoor(Vector(1.02, 0.0, 0.15));
  this->emissionPoint[1]->setRelCoor(Vector(1.02, 0.09, 0.0));
  this->emissionPoint[2]->setRelCoor(Vector(1.02, 0.0, -0.15));
  this->emissionPoint[3]->setRelCoor(Vector(1.02, -0.09, 0.0));

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}

void RFCannon::fire()
{
  for (int i = 0; i < this->getBarrels(); i++){
    Projectile* pj =  this->getProjectile();
    if (pj == NULL)
      return;

    // set the owner
    pj->setOwner(this->getOwner());

    pj->setParent(PNode::getNullParent());

    pj->setVelocity(this->getAbsDir().apply(Vector(0,1,0))*190);

    pj->setAbsCoor(this->emissionPoint[this->activeBarrel]->getAbsCoor());
    pj->setAbsDir(this->getAbsDir());
    pj->activate();

    this->activeBarrel = (this->activeBarrel + 1) % this->getBarrels();
  }
}

/**
 *  this activates the weapon
*/
void RFCannon::activate()
{
}

/**
 *  this deactivates the weapon
*/
void RFCannon::deactivate()
{
}

void RFCannon::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    static_cast<StaticModel*>(this->getModel())->draw();
  glPopMatrix();

}

void RFCannon::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_light_bolt.png");
    this->setEnergyWidgetInitialized(true);
  }
}
