/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer: Benjamin Grauer

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "mbolt.h"

#include "state.h"
#include "model.h"

#include "world_entities/npcs/npc.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"

#include "space_ships/space_ship.h"

#include <cassert>
#include "debug.h"

#include "static_model.h"

#include "effects/trail.h"



ObjectListDefinition(MBolt);
CREATE_FAST_FACTORY_STATIC(MBolt);

/**
 *  standard constructor
*/
MBolt::MBolt () : Projectile()
{
  this->registerObject(this, MBolt::_objectList);
  this->loadModel("models/projectiles/mbolt.obj",4);


  //this->loadModel("models/projectiles/laser.obj");

  this->setMinEnergy(4);
  this->setHealthMax(0);
  this->lifeSpan = 1.5;
  this->angle     = 0;

  //this->emitter = new DotEmitter(1000, 0, 0);
  this->emitter = new DotEmitter(50, 0, 0);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI,M_PI);
  this->emitter->setInheritSpeed(this->velocity.len());
  this->emitter->setEmissionRate(500.0);
  this->emitter->setEmissionVelocity(this->velocity.len());

  this->mat = new Material("mBolt");
  //this->mat->setBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
  this->mat->setBlendFunc(GL_SRC_ALPHA,GL_ONE);
  this->mat->setDiffuse(1,1,1);
  this->mat->setDiffuseMap("laser_add.png");
  this->mat->setDiffuseMap("laser.png",1);

  dynamic_cast<StaticModel*>(this->getModel())->addMaterial(*this->mat);
  dynamic_cast<StaticModel*>(this->getModel())->finalize();

  dynamic_cast<StaticModel*>(this->getModel())->rebuild();
  //this->buildObbTree(4);

  this->trail = new Trail(6, 4, .1, this);
  //this->trail->setParent( this);
  this->trail->setTexture( "textures/laser.png");
//   this->trail->setAbsCoor(this->getAbsCoor() - Vector(.7,0,0));
  this->trail->setAbsCoor(this->getAbsCoor() - this->getVelocity().getNormalized() * .7);

}


/**
 *  standard deconstructor
 *
 */
MBolt::~MBolt ()
{

  if (MBolt::explosionParticles != NULL && MBolt::objectList().size() <= 1)
  {
    if (ParticleSystem::objectList().exists(MBolt::explosionParticles))
      delete MBolt::explosionParticles;
    MBolt::explosionParticles = NULL;
    PRINTF(1)("Deleting MBolt Explosion Particles\n");
  }

  delete this->emitter;
  delete this->trail;
}

SpriteParticles* MBolt::explosionParticles = NULL;

void MBolt::activate()
{
  this->origList = this->getOMListNumber();
  this->toList(OM_ENVIRON);
  if (unlikely(MBolt::explosionParticles == NULL))
  {
    MBolt::explosionParticles = new SpriteParticles(1000);
    MBolt::explosionParticles->setName("MBoltExplosionParticles");
    MBolt::explosionParticles->setLifeSpan(.2, .1);
    MBolt::explosionParticles->setRadius(0.0, 10.0);
    MBolt::explosionParticles->setRadius(.5, 6.0);
    MBolt::explosionParticles->setRadius(1.0, 3.0);
    MBolt::explosionParticles->setColor(0.0, 1,1,0,.9);
    MBolt::explosionParticles->setColor(0.5, .8,.8,0,.5);
    MBolt::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setPhysDamage(10);
  this->setElecDamage(0);
  this->setHealth(0);

  this->emitter->setSpread(0);
  this->emitter->setEmissionRate(10.0);
  this->emitter->setEmissionVelocity(50);
}


void MBolt::deactivate()
{
  assert (MBolt::explosionParticles != NULL);
  MBolt::explosionParticles->removeEmitter(this->emitter);
  this->lifeCycle = 0.0;

  this->lifeCycle = 0.0;
  this->toList(OM_NULL);
  //this->toList(OM_DEAD);
  this->removeNode();
  MBolt::fastFactory->kill(this);
}

void MBolt::hit (float damage, WorldEntity* entity )
{

  if (this->hitEntity != entity)
    this->destroy( entity );
  this->hitEntity = entity;
 // dynamic_cast<SpaceShip*>(entity)->damage(this->getPhysDamage(),this->getElecDamage());
  //this->destroy(this);
  this->deactivate();

  return;

}

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void MBolt::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  this->angle += MBolt::rotationSpeed * dt;
  this->trail->tick(dt);

  for( ObjectList<NPC>::const_iterator eIterator = NPC::objectList().begin(); eIterator !=NPC::objectList().end(); eIterator++)
  {
    if( ((*eIterator)->getOMListNumber() != (this->origList -1))  && ((*eIterator)->getAbsCoor() - this->getAbsCoor()).len() <= 8)
    {
      (*eIterator)->destroy(this); //hit (this->getDamage(),this);
      this->deactivate();
      PRINTF(0)("MBolt destroyed\n");
    }
  }
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void MBolt::destroy (WorldEntity* killer)
{
  //this->deactivate();
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY MBolt\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(MBolt::explosionParticles);
}


void MBolt::draw () const
{
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);

  glPushMatrix();
  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
//   glRotatef(this->angle, 1.0f, 0.0f, 0.0f); //spinning missile
  glRotatef(this->angle, this->flightDirection.x, this->flightDirection.y, this->flightDirection.z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);

  glScalef(0.75/4, 0.7/16, 0.7/16);  // no double rescale

  this->mat->select();
  dynamic_cast<StaticModel*>(this->getModel())->draw();
  this->mat->unselect();
  glScalef(4/.75,16/.7,16/.7);
  glTranslatef(-3,0,0);
  this->trail->draw();
  glPopMatrix();
  glPopAttrib();

}
