/*!
 * @file billboard.h
 */

#ifndef _BILLBOARD_H
#define _BILLBOARD_H

#include "world_entity.h"

class Material;
class TiXmlElement;
class Color;

class Billboard : public WorldEntity
{
  ObjectListDeclaration(Billboard);
  public:
    Billboard(const TiXmlElement* root = NULL);
    virtual ~Billboard();

    void init();
    void loadParams(const TiXmlElement* root);

    void setSize(float sizeX, float sizeY);
    void setTexture(const std::string& textureFile);
    void colorTexture(const Color col);

    inline void togglePluse () {this->bPulse = !bPulse; };
    inline void setPulse () { this->bPulse = true; };
    inline void setPulse ( bool state ) {this->bPulse = state; };
    inline float getPulse () { return this->bPulse; };

    virtual void tick(float dt);
    virtual void draw() const;

    inline void setUpdateFunction(float (*updateFct)(float value)) { if( updateFct)  this->updatePulse = updateFct;};

  private:

    float (*updatePulse)(float value);

    Material*        material;
    Color*           texColor;
    float sizeX;
    float sizeY;

    bool bPulse;
    float pulseMagnitude;
    float angle;
    float angularSpeed;
};

#endif /* _BILLBOARD_H */
