/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file IceGun.h
    @brief Definition of the IceGun class.
*/

#ifndef _IceGun_H__
#define _IceGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A Gun that fires ice arrows that slow down any SpaceShip object that gets hit.
    @author
        Fabien Vultier
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport IceGun : public WeaponMode
    {
        public:
            IceGun(Context* context);
            virtual ~IceGun();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
            virtual void fire();
            
            inline void setFreezeTime(float freezeTime)
                { this->freezeTime_ = freezeTime; }
            inline float getFreezeTime() const
                { return this->freezeTime_; }
            inline void setFreezeFactor(float freezeFactor)
                { this->freezeFactor_ = freezeFactor; }
            inline float getFreezeFactor() const
                { return this->freezeFactor_; }

       private:
            float speed_; //The speed of the fired projectile.
            float freezeTime_; //The duration of the freezing effect on a target
            float freezeFactor_; //The strength of the freezing effect
    };
}

#endif /* _IceGun_H__ */
