/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file IceGunProjectile.h
    @brief Definition of the SplitGunProjectile class.
*/

#ifndef _SplitGunProjectile_H__
#define _SplitGunProjectile_H__

#include "weapons/WeaponsPrereqs.h"

#include <string>
#include "tools/Timer.h"
#include "BillboardProjectile.h"

namespace orxonox
{

    /**
    @brief
        The SplitGunProjectile is a projectile that may split up into many child projectiles.
    @author
        Fabien Vultier
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport SplitGunProjectile : public BillboardProjectile
    {
        public:
            SplitGunProjectile(Context* context);
            virtual ~SplitGunProjectile() {}

            virtual void setNumberOfSplits(int numberOfSplits);
            virtual void setNumberOfChilds(int numberOfChilds);
            virtual void setSplitTime(float splitTime);
            virtual void setSpread(float spread);
            virtual void setDamageReduction(float damageReduction);

        private:            
            int numberOfSplits_;
            int numberOfChilds_;
            float splitTime_;
            float spread_;
            float damageReduction_; //The damage of a child projectile is reduced by this factor
            Timer splitTimer_;

            virtual void split();            
    };
}

#endif /* _SplitGunProjectile_H__ */
