/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file IceGunFreezer.h
    @brief Definition of the IceGunFreezer class.
*/

#ifndef _IceGunFreezer_H__
#define _IceGunFreezer_H__

#include "weapons/WeaponsPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "worldentities/StaticEntity.h"
#include "graphics/Model.h"
#include "tools/Timer.h"  
#include "worldentities/pawns/SpaceShip.h"  

namespace orxonox
{
    /**
    @brief
        This is the WorldEntity that gets attached to a victim hit by a IceGunProjectile. It slows down the hit SpaceShip by a defined amount and time.
    @ingroup Weapons
    */
    class _WeaponsExport IceGunFreezer : public StaticEntity, public Tickable
    {
        public:
            IceGunFreezer(Context* context);
            virtual ~IceGunFreezer();
            virtual void tick(float dt);
            virtual void startFreezing();
            virtual void stopFreezing();
            virtual void setFreezeTime(float freezeTime);
            virtual void setFreezeFactor(float freezeFactor);
        private:
            float freezeTime_; //The duration of the freezing effect on a target
            float freezeFactor_; //The strength of the freezing effect            
            Model* model;
            Timer freezeTimer_;
            WeakPtr<SpaceShip> freezedSpaceShip_;
    };
}

#endif /* _IceGunFreezer_H__ */
