/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *
 *   Co-authors:
 *      ...
 *
 */

 /**
    @brief
        GameType class for TowerDefense. See TowerDefenseReadme.txt for Information.

    @ingroup TowerDefense
 */


#ifndef _TowerDefense_H__
#define _TowerDefense_H__
#include "TDCoordinate.h"
#include "TowerDefenseSelecter.h"
#include "towerdefense/TowerDefensePrereqs.h"
#include "gametypes/TeamDeathmatch.h"
#include "TowerDefenseEnemy.h"
#include "util/Output.h"
#include "TowerDefenseField.h"

namespace orxonox
{
    class _TowerDefenseExport TowerDefense : public TeamDeathmatch
    {
    public:
        TowerDefense(Context* context);
        virtual ~TowerDefense();        
        void addTowerDefenseEnemy(int templatenr);
        virtual void start(); //<! The function is called when the gametype starts
        virtual void end();
        virtual void tick(float dt);
        virtual void spawnPlayer(PlayerInfo* player);
        PlayerInfo* getPlayer(void) const;
        int getCredit(){ return this->credit_; }
        void payCredit(int pay){ this->credit_ -= pay; }
        int getLifes(){ return this->lifes_; }
        int getWaveNumber(){ return this->waveNumber_; }
        void setWaveNumber(int wavenumber){ waveNumber_=wavenumber; }
        void setCredit(int credit){ credit_ = credit; }
        void setLifes(int lifes){ lifes_ = lifes; }        
        void buyTower(int cost){ cost -= cost;}
        void addCredit(int credit) { credit_+=credit; }
        int reduceLifes(int NumberofLifes){ return lifes_-=NumberofLifes; }
        TowerDefenseField* getField(TDCoordinate* coord){ return fields_[coord->GetX()][coord->GetY()]; }
        void setCenterpoint(TowerDefenseCenterpoint* centerpoint);        
        void addTower(int x, int y);
        void upgradeTower(int x, int y); 
        virtual TDCoordinate* getNextStreetCoord(TDCoordinate*);
        
        TowerDefenseSelecter* selecter;        

    private:
        void createFields();

        orxonox::WeakPtr<TowerDefenseCenterpoint> center_;
        PlayerInfo* player_;
        float timeSinceLastSpawn_;
        float timeUntilNextWave_;
        int waveSize_;
        int credit_;
        int waveNumber_;
        int lifes_;
        std::list<orxonox::WeakPtr<TowerDefenseEnemy> > enemies_;
        TowerDefenseField* fields_[16][16];
        std::vector<orxonox::WeakPtr<TowerDefenseField> > waypoints_;
        Vector3 endpoint_;
        Vector3 offset_;        
    };
}

#endif /* _TowerDefense_H__ */
