/*!
 * @file space_trigger.h
 *  triggeres a script when a world_entity is in range
 */

#ifndef _SPACE_TRIGGER_H
#define _SPACE_TRIGGER_H

#include <string>

#include "script.h"
#include "script_class.h"
#include "script_trigger.h"

class SpaceTrigger : public ScriptTrigger
{
  ObjectListDeclaration(SpaceTrigger);
  
  public:
    SpaceTrigger(const TiXmlElement* root = NULL);
    ~SpaceTrigger();
    
    ///LOADING
    virtual void loadParams(const TiXmlElement* root);


    /// DO WORK
    virtual void tick(float timestep);


    /// SET MEMBER
    void setTarget(const std::string& targetName);
    void setTarget(WorldEntity* target) { if(target!=NULL) this->target=target; }
    void setTriggerRemains(const bool lasts) { this->triggerRemains = lasts; }
    void setInvert(const bool inv) { this->invert = invert; }
    void setRadius(const float radius) { if(radius>0) this->radius = radius; }


  private:

    WorldEntity* target;
    bool         triggerRemains;
    bool         invert;
    float        radius;


};


#endif
